/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.message.request.AbstractImapRequest;

public class SetQuotaRequest
extends AbstractImapRequest {
    private final String quotaRoot;
    private final List<ResourceLimit> resourceLimits;

    public SetQuotaRequest(String tag, ImapCommand command, String quotaRoot) {
        super(tag, command);
        this.quotaRoot = quotaRoot;
        this.resourceLimits = new ArrayList<ResourceLimit>();
    }

    public void addResourceLimit(String resource, long limit) {
        this.resourceLimits.add(new ResourceLimit(resource, limit));
    }

    public List<ResourceLimit> getResourceLimits() {
        return new ArrayList<ResourceLimit>(this.resourceLimits);
    }

    public String getQuotaRoot() {
        return this.quotaRoot;
    }

    public class ResourceLimit {
        private final String resource;
        private final Long limit;

        public ResourceLimit(String resource, long limit) {
            this.limit = limit;
            this.resource = resource;
        }

        public String getResource() {
            return this.resource;
        }

        public long getLimit() {
            return this.limit;
        }
    }
}

