/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.message.request.AbstractImapRequest;

public abstract class AbstractMailboxSelectionRequest
extends AbstractImapRequest {
    private final String mailboxName;
    private final boolean condstore;
    private final Long lastKnownUidValidity;
    private final Long knownModSeq;
    private final UidRange[] uidSet;
    private final UidRange[] knownUidSet;
    private final IdRange[] knownSequenceSet;

    public AbstractMailboxSelectionRequest(ImapCommand command, String mailboxName, boolean condstore, Long lastKnownUidValidity, Long knownModSeq, UidRange[] uidSet, UidRange[] knownUidSet, IdRange[] knownSequenceSet, String tag) {
        super(tag, command);
        this.mailboxName = mailboxName;
        this.condstore = condstore;
        this.lastKnownUidValidity = lastKnownUidValidity;
        this.knownModSeq = knownModSeq;
        if (lastKnownUidValidity == null && knownModSeq != null || this.lastKnownUidValidity != null && knownModSeq == null) {
            throw new IllegalArgumentException();
        }
        this.uidSet = uidSet;
        this.knownUidSet = knownUidSet;
        this.knownSequenceSet = knownSequenceSet;
    }

    public final String getMailboxName() {
        return this.mailboxName;
    }

    public final boolean getCondstore() {
        return this.condstore;
    }

    public final Long getLastKnownUidValidity() {
        return this.lastKnownUidValidity;
    }

    public final Long getKnownModSeq() {
        return this.knownModSeq;
    }

    public final UidRange[] getUidSet() {
        return this.uidSet;
    }

    public final IdRange[] getKnownSequenceSet() {
        return this.knownSequenceSet;
    }

    public final UidRange[] getKnownUidSet() {
        return this.knownUidSet;
    }
}

