/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.QuotaResponse;
import org.apache.james.mailbox.model.Quota;

public class QuotaResponseEncoder
extends AbstractChainedImapEncoder {
    public QuotaResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        QuotaResponse quotaResponse = (QuotaResponse)acceptableMessage;
        String quotaRoot = quotaResponse.getQuotaRoot();
        Quota quota = quotaResponse.getQuota();
        composer.untagged();
        composer.commandName("QUOTA");
        composer.message(quotaRoot == null ? "" : quotaRoot);
        composer.openParen();
        composer.message(quotaResponse.getResourceName());
        if (quotaResponse.getResourceName().equalsIgnoreCase("STORAGE")) {
            composer.message(quota.getUsed() / 1024L);
            composer.message(quota.getMax() / 1024L);
        } else {
            composer.message(quota.getUsed());
            composer.message(quota.getMax());
        }
        composer.closeParen();
        composer.end();
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof QuotaResponse;
    }
}

