/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.List;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.NamespaceResponse;

public class NamespaceResponseEncoder
extends AbstractChainedImapEncoder {
    public NamespaceResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        NamespaceResponse response = (NamespaceResponse)acceptableMessage;
        composer.untagged();
        composer.commandName("NAMESPACE");
        List<NamespaceResponse.Namespace> personal = response.getPersonal();
        this.encode(personal, composer);
        List<NamespaceResponse.Namespace> users = response.getUsers();
        this.encode(users, composer);
        List<NamespaceResponse.Namespace> shared = response.getShared();
        this.encode(shared, composer);
        composer.end();
    }

    private void encode(List<NamespaceResponse.Namespace> namespaces, ImapResponseComposer composer) throws IOException {
        if (namespaces == null || namespaces.isEmpty()) {
            composer.nil();
        } else {
            composer.openParen();
            for (NamespaceResponse.Namespace namespace : namespaces) {
                this.encode(namespace, composer);
            }
            composer.closeParen();
        }
    }

    private void encode(NamespaceResponse.Namespace namespace, ImapResponseComposer composer) throws IOException {
        composer.openParen();
        String prefix = namespace.getPrefix();
        String delimiter = Character.toString(namespace.getDelimiter());
        if (prefix.length() > 0) {
            prefix = prefix + delimiter;
        }
        composer.quote(prefix);
        composer.quote(delimiter);
        composer.closeParen();
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message instanceof NamespaceResponse;
    }
}

