/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.mail.Flags;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.EncoderUtils;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.FetchResponse;
import org.apache.james.mailbox.MessageUid;
import org.slf4j.Logger;

public class FetchResponseEncoder
extends AbstractChainedImapEncoder {
    public static final String ENVELOPE = "ENVELOPE";
    private final boolean neverAddBodyStructureExtensions;

    public FetchResponseEncoder(ImapEncoder next, boolean neverAddBodyStructureExtensions) {
        super(next);
        this.neverAddBodyStructureExtensions = neverAddBodyStructureExtensions;
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof FetchResponse;
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        if (acceptableMessage instanceof FetchResponse) {
            FetchResponse fetchResponse = (FetchResponse)acceptableMessage;
            long messageNumber = fetchResponse.getMessageNumber();
            composer.untagged().message(messageNumber).message("FETCH").openParen();
            this.encodeModSeq(composer, fetchResponse);
            this.encodeFlags(composer, fetchResponse);
            this.encodeInternalDate(composer, fetchResponse);
            this.encodeSize(composer, fetchResponse);
            this.encodeEnvelope(composer, fetchResponse);
            this.encodeBody(composer, fetchResponse.getBody(), session);
            this.encodeBodyStructure(composer, fetchResponse.getBodyStructure(), session);
            this.encodeUid(composer, fetchResponse);
            this.encodeBodyElements(composer, fetchResponse.getElements());
            composer.closeParen().end();
        }
    }

    private void encodeModSeq(ImapResponseComposer composer, FetchResponse response) throws IOException {
        Long modSeq = response.getModSeq();
        if (modSeq != null) {
            composer.message("MODSEQ");
            composer.openParen();
            composer.skipNextSpace();
            composer.message(modSeq);
            composer.closeParen();
        }
    }

    private void encodeBody(ImapResponseComposer composer, FetchResponse.Structure body, ImapSession session) throws IOException {
        if (body != null) {
            composer.message("BODY");
            this.encodeStructure(composer, body, false, false, session);
        }
    }

    private void encodeBodyStructure(ImapResponseComposer composer, FetchResponse.Structure bodyStructure, ImapSession session) throws IOException {
        if (bodyStructure != null) {
            composer.message("BODYSTRUCTURE");
            this.encodeStructure(composer, bodyStructure, true, false, session);
        }
    }

    private void encodeStructure(ImapResponseComposer composer, FetchResponse.Structure structure, boolean includeExtensions, boolean isInnerPart, ImapSession session) throws IOException {
        String subType;
        String mediaType;
        String rawMediaType = structure.getMediaType();
        if (rawMediaType == null) {
            mediaType = "TEXT";
            subType = "PLAIN";
        } else {
            mediaType = rawMediaType;
            subType = structure.getSubType();
        }
        this.encodeStructure(composer, structure, includeExtensions, mediaType, subType, isInnerPart, session);
    }

    private void encodeStructure(ImapResponseComposer composer, FetchResponse.Structure structure, boolean includeExtensions, String mediaType, String subType, boolean isInnerPart, ImapSession session) throws IOException {
        boolean includeOptionalExtensions;
        boolean bl = includeOptionalExtensions = includeExtensions && !this.neverAddBodyStructureExtensions;
        if (isInnerPart) {
            composer.skipNextSpace();
        }
        if ("MULTIPART".equalsIgnoreCase(mediaType)) {
            this.encodeMultipart(composer, structure, subType, includeOptionalExtensions, session);
        } else if ("MESSAGE".equalsIgnoreCase(mediaType) && "RFC822".equalsIgnoreCase(subType)) {
            this.encodeRfc822Message(composer, structure, mediaType, subType, includeOptionalExtensions, session);
        } else {
            this.encodeBasic(composer, structure, includeOptionalExtensions, mediaType, subType, session);
        }
    }

    private void encodeBasic(ImapResponseComposer composer, FetchResponse.Structure structure, boolean includeExtensions, String mediaType, String subType, ImapSession session) throws IOException {
        if ("TEXT".equalsIgnoreCase(mediaType)) {
            long lines = structure.getLines();
            this.encodeBodyFields(composer, structure, mediaType, subType);
            composer.message(lines);
        } else {
            this.encodeBodyFields(composer, structure, mediaType, subType);
        }
        if (includeExtensions) {
            this.encodeOnePartBodyExtensions(composer, structure, session);
        }
        composer.closeParen();
    }

    private void encodeOnePartBodyExtensions(ImapResponseComposer composer, FetchResponse.Structure structure, ImapSession session) throws IOException {
        String md5 = structure.getMD5();
        List<String> languages = structure.getLanguages();
        String location = structure.getLocation();
        this.nillableQuote(composer, md5);
        this.bodyFldDsp(structure, composer, session);
        this.nillableQuotes(composer, languages);
        this.nillableQuote(composer, location);
    }

    private ImapResponseComposer bodyFldDsp(FetchResponse.Structure structure, ImapResponseComposer composer, ImapSession session) throws IOException {
        String disposition = structure.getDisposition();
        if (disposition == null) {
            composer.nil();
        } else {
            composer.openParen();
            composer.quote(disposition);
            Map<String, String> params = structure.getDispositionParams();
            this.bodyFldParam(params, composer, session);
            composer.closeParen();
        }
        return composer;
    }

    private void bodyFldParam(Map<String, String> params, ImapResponseComposer composer, ImapSession session) throws IOException {
        if (params == null || params.isEmpty()) {
            composer.nil();
        } else {
            composer.openParen();
            Set<String> keySet = params.keySet();
            TreeSet<String> names = new TreeSet<String>(keySet);
            for (String name : names) {
                String value = params.get(name);
                if (value == null) {
                    Logger logger = session.getLog();
                    logger.warn("Disposition parameter name has no value.");
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Disposition parameter " + name + " has no matching value");
                    continue;
                }
                composer.quote(name);
                composer.quote(value);
            }
            composer.closeParen();
        }
    }

    private void encodeBodyFields(ImapResponseComposer composer, FetchResponse.Structure structure, String mediaType, String subType) throws IOException {
        List<String> bodyParams = structure.getParameters();
        String id = structure.getId();
        String description = structure.getDescription();
        String encoding = structure.getEncoding();
        long octets = structure.getOctets();
        composer.openParen().quoteUpperCaseAscii(mediaType).quoteUpperCaseAscii(subType);
        this.nillableQuotes(composer, bodyParams);
        this.nillableQuote(composer, id);
        this.nillableQuote(composer, description);
        composer.quoteUpperCaseAscii(encoding).message(octets);
    }

    private void encodeMultipart(ImapResponseComposer composer, FetchResponse.Structure structure, String subType, boolean includeExtensions, ImapSession session) throws IOException {
        composer.openParen();
        Iterator<FetchResponse.Structure> it = structure.parts();
        while (it.hasNext()) {
            FetchResponse.Structure part = it.next();
            this.encodeStructure(composer, part, includeExtensions, true, session);
        }
        composer.quoteUpperCaseAscii(subType);
        if (includeExtensions) {
            List<String> languages = structure.getLanguages();
            this.nillableQuotes(composer, structure.getParameters());
            this.bodyFldDsp(structure, composer, session);
            this.nillableQuotes(composer, languages);
            this.nillableQuote(composer, structure.getLocation());
        }
        composer.closeParen();
    }

    private void encodeRfc822Message(ImapResponseComposer composer, FetchResponse.Structure structure, String mediaType, String subType, boolean includeExtensions, ImapSession session) throws IOException {
        long lines = structure.getLines();
        FetchResponse.Envelope envelope = structure.getEnvelope();
        FetchResponse.Structure embeddedStructure = structure.getBody();
        this.encodeBodyFields(composer, structure, mediaType, subType);
        this.encodeEnvelope(composer, envelope, false);
        this.encodeStructure(composer, embeddedStructure, includeExtensions, false, session);
        composer.message(lines);
        if (includeExtensions) {
            this.encodeOnePartBodyExtensions(composer, structure, session);
        }
        composer.closeParen();
    }

    private void encodeBodyElements(ImapResponseComposer composer, List<FetchResponse.BodyElement> elements) throws IOException {
        if (elements != null) {
            for (FetchResponse.BodyElement element : elements) {
                String name = element.getName();
                composer.message(name);
                composer.literal(element);
            }
        }
    }

    private void encodeSize(ImapResponseComposer composer, FetchResponse fetchResponse) throws IOException {
        Long size = fetchResponse.getSize();
        if (size != null) {
            composer.message("RFC822.SIZE");
            composer.message(size.intValue());
        }
    }

    private void encodeInternalDate(ImapResponseComposer composer, FetchResponse fetchResponse) throws IOException {
        Date internalDate = fetchResponse.getInternalDate();
        if (internalDate != null) {
            composer.message("INTERNALDATE");
            composer.quote(EncoderUtils.encodeDateTime(internalDate));
        }
    }

    private void encodeUid(ImapResponseComposer composer, FetchResponse fetchResponse) throws IOException {
        MessageUid uid = fetchResponse.getUid();
        if (uid != null) {
            composer.message("UID");
            composer.message(uid.asLong());
        }
    }

    private void encodeFlags(ImapResponseComposer composer, FetchResponse fetchResponse) throws IOException {
        Flags flags = fetchResponse.getFlags();
        if (flags != null) {
            composer.flags(flags);
        }
    }

    private void encodeEnvelope(ImapResponseComposer composer, FetchResponse fetchResponse) throws IOException {
        FetchResponse.Envelope envelope = fetchResponse.getEnvelope();
        this.encodeEnvelope(composer, envelope, true);
    }

    private void encodeEnvelope(ImapResponseComposer composer, FetchResponse.Envelope envelope, boolean prefixWithName) throws IOException {
        if (envelope != null) {
            String date = envelope.getDate();
            String subject = envelope.getSubject();
            FetchResponse.Envelope.Address[] from = envelope.getFrom();
            FetchResponse.Envelope.Address[] sender = envelope.getSender();
            FetchResponse.Envelope.Address[] replyTo = envelope.getReplyTo();
            FetchResponse.Envelope.Address[] to = envelope.getTo();
            FetchResponse.Envelope.Address[] cc = envelope.getCc();
            FetchResponse.Envelope.Address[] bcc = envelope.getBcc();
            String inReplyTo = envelope.getInReplyTo();
            String messageId = envelope.getMessageId();
            if (prefixWithName) {
                composer.message(ENVELOPE);
            }
            composer.openParen();
            this.nillableQuote(composer, date);
            this.nillableQuote(composer, subject);
            this.encodeAddresses(composer, from);
            this.encodeAddresses(composer, sender);
            this.encodeAddresses(composer, replyTo);
            this.encodeAddresses(composer, to);
            this.encodeAddresses(composer, cc);
            this.encodeAddresses(composer, bcc);
            this.nillableQuote(composer, inReplyTo);
            this.nillableQuote(composer, messageId);
            composer.closeParen();
        }
    }

    private void encodeAddresses(ImapResponseComposer composer, FetchResponse.Envelope.Address[] addresses) throws IOException {
        if (addresses == null || addresses.length == 0) {
            composer.nil();
        } else {
            composer.openParen();
            for (FetchResponse.Envelope.Address address : addresses) {
                this.encodeAddress(composer, address);
            }
            composer.closeParen();
        }
    }

    private void encodeAddress(ImapResponseComposer composer, FetchResponse.Envelope.Address address) throws IOException {
        String name = address.getPersonalName();
        String domainList = address.getAtDomainList();
        String mailbox = address.getMailboxName();
        String host = address.getHostName();
        composer.skipNextSpace().openParen();
        this.nillableQuote(composer, name);
        this.nillableQuote(composer, domainList);
        this.nillableQuote(composer, mailbox);
        this.nillableQuote(composer, host).closeParen();
    }

    private ImapResponseComposer nillableQuote(ImapResponseComposer composer, String message) throws IOException {
        if (message == null) {
            composer.nil();
        } else {
            composer.quote(message);
        }
        return composer;
    }

    private ImapResponseComposer nillableQuotes(ImapResponseComposer composer, List<String> quotes) throws IOException {
        if (quotes == null || quotes.size() == 0) {
            composer.nil();
        } else {
            composer.openParen();
            for (String string : quotes) {
                this.nillableQuote(composer, string);
            }
            composer.closeParen();
        }
        return composer;
    }
}

