/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.List;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.SearchResultOption;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.ESearchResponse;

public class ESearchResponseEncoder
extends AbstractChainedImapEncoder {
    public ESearchResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        ESearchResponse response = (ESearchResponse)acceptableMessage;
        String tag = response.getTag();
        long min = response.getMinUid();
        long max = response.getMaxUid();
        long count = response.getCount();
        IdRange[] all = response.getAll();
        UidRange[] allUids = response.getAllUids();
        boolean useUid = response.getUseUid();
        Long highestModSeq = response.getHighestModSeq();
        List<SearchResultOption> options = response.getSearchResultOptions();
        composer.untagged().message("ESEARCH").openParen().message("TAG").quote(tag).closeParen();
        if (useUid) {
            composer.message("UID");
        }
        if (min > -1L && options.contains((Object)SearchResultOption.MIN)) {
            composer.message(SearchResultOption.MIN.name()).message(min);
        }
        if (max > -1L && options.contains((Object)SearchResultOption.MAX)) {
            composer.message(SearchResultOption.MAX.name()).message(max);
        }
        if (options.contains((Object)SearchResultOption.COUNT)) {
            composer.message(SearchResultOption.COUNT.name()).message(count);
        }
        if (!useUid && all != null && all.length > 0 && options.contains((Object)SearchResultOption.ALL)) {
            composer.message(SearchResultOption.ALL.name());
            composer.sequenceSet(all);
        }
        if (useUid && allUids != null && allUids.length > 0 && options.contains((Object)SearchResultOption.ALL)) {
            composer.message(SearchResultOption.ALL.name());
            composer.sequenceSet(allUids);
        }
        if (highestModSeq != null) {
            composer.message("MODSEQ");
            composer.message(highestModSeq);
        }
        composer.end();
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message instanceof ESearchResponse;
    }
}

