/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.List;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.AnnotationResponse;
import org.apache.james.mailbox.model.MailboxAnnotation;

public class AnnotationResponseEncoder
extends AbstractChainedImapEncoder {
    public AnnotationResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        AnnotationResponse response = (AnnotationResponse)acceptableMessage;
        composer.untagged();
        composer.commandName("METADATA");
        composer.quote((String)Optional.fromNullable((Object)response.getMailboxName()).or((Object)""));
        this.composeAnnotations(composer, session, response.getMailboxAnnotations());
        composer.end();
    }

    private void composeAnnotations(ImapResponseComposer composer, ImapSession session, List<MailboxAnnotation> annotations) throws IOException {
        if (!annotations.isEmpty()) {
            composer.openParen();
            for (MailboxAnnotation annotation : annotations) {
                this.composeAnnotation(composer, session, annotation);
            }
            composer.closeParen();
        }
    }

    private void composeAnnotation(ImapResponseComposer composer, ImapSession session, MailboxAnnotation annotation) throws IOException {
        if (annotation.isNil()) {
            session.getLog().warn("There is nil data of key {} on store: ", (Object)annotation.getKey().asString());
        } else {
            composer.message(annotation.getKey().asString());
            composer.quote((String)annotation.getValue().or((Object)""));
        }
    }

    @Override
    public boolean isAcceptable(ImapMessage message) {
        return message instanceof AnnotationResponse;
    }
}

