/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.SetAnnotationRequest;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.protocols.imap.DecodingException;

public class SetAnnotationCommandParser
extends AbstractImapCommandParser {
    public SetAnnotationCommandParser() {
        super(ImapCommand.authenticatedStateCommand("SETMETADATA"));
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        ImmutableList.Builder listMailboxAnnotations = ImmutableList.builder();
        if (request.nextWordChar() == '(') {
            request.consumeChar('(');
            do {
                listMailboxAnnotations.add((Object)this.readNextAnnotation(request));
            } while (request.nextWordChar() != ')');
            request.consumeChar(')');
        }
        request.eol();
        return new SetAnnotationRequest(tag, command, mailboxName, (List<MailboxAnnotation>)listMailboxAnnotations.build());
    }

    private MailboxAnnotation readNextAnnotation(ImapRequestLineReader request) throws DecodingException {
        try {
            String key = request.atom();
            String value = request.nstring();
            return (MailboxAnnotation)Optional.fromNullable((Object)value).transform(this.transforMailboxAnnotation(key)).or((Object)MailboxAnnotation.nil((MailboxAnnotationKey)this.createAnnotationKey(key)));
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "The key is not valid: " + e.getMessage());
        }
    }

    private Function<String, MailboxAnnotation> transforMailboxAnnotation(final String key) {
        return new Function<String, MailboxAnnotation>(){

            public MailboxAnnotation apply(String value) {
                return MailboxAnnotation.newInstance((MailboxAnnotationKey)SetAnnotationCommandParser.this.createAnnotationKey(key), (String)value);
            }
        };
    }

    private MailboxAnnotationKey createAnnotationKey(String key) {
        return new MailboxAnnotationKey(key);
    }
}

