/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.decode.DelegatingImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParser;
import org.apache.james.imap.decode.ImapCommandParserFactory;
import org.apache.james.imap.decode.MessagingImapCommandParser;
import org.apache.james.imap.decode.parser.AppendCommandParser;
import org.apache.james.imap.decode.parser.AuthenticateCommandParser;
import org.apache.james.imap.decode.parser.CapabilityCommandParser;
import org.apache.james.imap.decode.parser.CheckCommandParser;
import org.apache.james.imap.decode.parser.CloseCommandParser;
import org.apache.james.imap.decode.parser.CompressCommandParser;
import org.apache.james.imap.decode.parser.CopyCommandParser;
import org.apache.james.imap.decode.parser.CreateCommandParser;
import org.apache.james.imap.decode.parser.DeleteACLCommandParser;
import org.apache.james.imap.decode.parser.DeleteCommandParser;
import org.apache.james.imap.decode.parser.EnableCommandParser;
import org.apache.james.imap.decode.parser.ExamineCommandParser;
import org.apache.james.imap.decode.parser.ExpungeCommandParser;
import org.apache.james.imap.decode.parser.FetchCommandParser;
import org.apache.james.imap.decode.parser.GetACLCommandParser;
import org.apache.james.imap.decode.parser.GetAnnotationCommandParser;
import org.apache.james.imap.decode.parser.GetQuotaCommandParser;
import org.apache.james.imap.decode.parser.GetQuotaRootCommandParser;
import org.apache.james.imap.decode.parser.IdleCommandParser;
import org.apache.james.imap.decode.parser.ListCommandParser;
import org.apache.james.imap.decode.parser.ListRightsCommandParser;
import org.apache.james.imap.decode.parser.LoginCommandParser;
import org.apache.james.imap.decode.parser.LogoutCommandParser;
import org.apache.james.imap.decode.parser.LsubCommandParser;
import org.apache.james.imap.decode.parser.MoveCommandParser;
import org.apache.james.imap.decode.parser.MyRightsCommandParser;
import org.apache.james.imap.decode.parser.NamespaceCommandParser;
import org.apache.james.imap.decode.parser.NoopCommandParser;
import org.apache.james.imap.decode.parser.RenameCommandParser;
import org.apache.james.imap.decode.parser.SearchCommandParser;
import org.apache.james.imap.decode.parser.SelectCommandParser;
import org.apache.james.imap.decode.parser.SetACLCommandParser;
import org.apache.james.imap.decode.parser.SetAnnotationCommandParser;
import org.apache.james.imap.decode.parser.SetQuotaCommandParser;
import org.apache.james.imap.decode.parser.StartTLSCommandParser;
import org.apache.james.imap.decode.parser.StatusCommandParser;
import org.apache.james.imap.decode.parser.StoreCommandParser;
import org.apache.james.imap.decode.parser.SubscribeCommandParser;
import org.apache.james.imap.decode.parser.UidCommandParser;
import org.apache.james.imap.decode.parser.UnselectCommandParser;
import org.apache.james.imap.decode.parser.UnsubscribeCommandParser;
import org.apache.james.imap.decode.parser.XListCommandParser;

public class ImapParserFactory
implements ImapCommandParserFactory {
    private final Map<String, Class<?>> _imapCommands;
    private final StatusResponseFactory statusResponseFactory;

    public ImapParserFactory(StatusResponseFactory statusResponseFactory) {
        this.statusResponseFactory = statusResponseFactory;
        this._imapCommands = new HashMap();
        this._imapCommands.put("CAPABILITY", CapabilityCommandParser.class);
        this._imapCommands.put("NOOP", NoopCommandParser.class);
        this._imapCommands.put("LOGOUT", LogoutCommandParser.class);
        this._imapCommands.put("AUTHENTICATE", AuthenticateCommandParser.class);
        this._imapCommands.put("LOGIN", LoginCommandParser.class);
        this._imapCommands.put("SELECT", SelectCommandParser.class);
        this._imapCommands.put("EXAMINE", ExamineCommandParser.class);
        this._imapCommands.put("CREATE", CreateCommandParser.class);
        this._imapCommands.put("DELETE", DeleteCommandParser.class);
        this._imapCommands.put("RENAME", RenameCommandParser.class);
        this._imapCommands.put("SUBSCRIBE", SubscribeCommandParser.class);
        this._imapCommands.put("UNSUBSCRIBE", UnsubscribeCommandParser.class);
        this._imapCommands.put("LIST", ListCommandParser.class);
        this._imapCommands.put("XLIST", XListCommandParser.class);
        this._imapCommands.put("LSUB", LsubCommandParser.class);
        this._imapCommands.put("STATUS", StatusCommandParser.class);
        this._imapCommands.put("APPEND", AppendCommandParser.class);
        this._imapCommands.put("NAMESPACE", NamespaceCommandParser.class);
        this._imapCommands.put("GETACL", GetACLCommandParser.class);
        this._imapCommands.put("SETACL", SetACLCommandParser.class);
        this._imapCommands.put("DELETEACL", DeleteACLCommandParser.class);
        this._imapCommands.put("LISTRIGHTS", ListRightsCommandParser.class);
        this._imapCommands.put("MYRIGHTS", MyRightsCommandParser.class);
        this._imapCommands.put("CHECK", CheckCommandParser.class);
        this._imapCommands.put("CLOSE", CloseCommandParser.class);
        this._imapCommands.put("EXPUNGE", ExpungeCommandParser.class);
        this._imapCommands.put("COPY", CopyCommandParser.class);
        this._imapCommands.put("MOVE", MoveCommandParser.class);
        this._imapCommands.put("SEARCH", SearchCommandParser.class);
        this._imapCommands.put("FETCH", FetchCommandParser.class);
        this._imapCommands.put("STORE", StoreCommandParser.class);
        this._imapCommands.put("UID", UidCommandParser.class);
        this._imapCommands.put("IDLE", IdleCommandParser.class);
        this._imapCommands.put("STARTTLS", StartTLSCommandParser.class);
        this._imapCommands.put("UNSELECT", UnselectCommandParser.class);
        this._imapCommands.put("COMPRESS", CompressCommandParser.class);
        this._imapCommands.put("ENABLE", EnableCommandParser.class);
        this._imapCommands.put("GETQUOTAROOT", GetQuotaRootCommandParser.class);
        this._imapCommands.put("GETQUOTA", GetQuotaCommandParser.class);
        this._imapCommands.put("SETQUOTA", SetQuotaCommandParser.class);
        this._imapCommands.put("SETMETADATA", SetAnnotationCommandParser.class);
        this._imapCommands.put("GETMETADATA", GetAnnotationCommandParser.class);
    }

    @Override
    public ImapCommandParser getParser(String commandName) {
        Class<?> cmdClass = this._imapCommands.get(commandName.toUpperCase(Locale.US));
        if (cmdClass == null) {
            return null;
        }
        return this.createCommand(cmdClass);
    }

    private ImapCommandParser createCommand(Class<?> commandClass) {
        try {
            ImapCommandParser cmd = (ImapCommandParser)commandClass.newInstance();
            this.initialiseParser(cmd);
            return cmd;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create command instance: " + commandClass.getName(), e);
        }
    }

    protected void initialiseParser(ImapCommandParser cmd) {
        if (cmd instanceof DelegatingImapCommandParser) {
            ((DelegatingImapCommandParser)((Object)cmd)).setParserFactory(this);
        }
        if (cmd instanceof MessagingImapCommandParser) {
            MessagingImapCommandParser messagingImapCommandParser = (MessagingImapCommandParser)cmd;
            messagingImapCommandParser.setStatusResponseFactory(this.statusResponseFactory);
        }
    }
}

