/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.ImapSessionUtils;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.CreateRequest;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.protocols.imap.DecodingException;

public class CreateCommandParser
extends AbstractImapCommandParser {
    public CreateCommandParser() {
        super(ImapCommand.authenticatedStateCommand("CREATE"));
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        MailboxSession mailboxSession = ImapSessionUtils.getMailboxSession(session);
        if (mailboxSession != null && mailboxName.endsWith(Character.toString(mailboxSession.getPathDelimiter()))) {
            mailboxName = mailboxName.substring(0, mailboxName.length() - 1);
        }
        request.eol();
        return new CreateRequest(command, mailboxName, tag);
    }
}

