/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api.message.request;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.api.message.UidRange;
import org.apache.james.imap.api.message.request.DayMonthYear;

public final class SearchKey {
    public static final int TYPE_SEQUENCE_SET = 1;
    public static final int TYPE_UID = 2;
    public static final int TYPE_ALL = 3;
    public static final int TYPE_ANSWERED = 4;
    public static final int TYPE_DELETED = 5;
    public static final int TYPE_DRAFT = 6;
    public static final int TYPE_FLAGGED = 7;
    public static final int TYPE_NEW = 8;
    public static final int TYPE_OLD = 9;
    public static final int TYPE_RECENT = 10;
    public static final int TYPE_SEEN = 11;
    public static final int TYPE_UNANSWERED = 12;
    public static final int TYPE_UNDELETED = 13;
    public static final int TYPE_UNDRAFT = 14;
    public static final int TYPE_UNFLAGGED = 15;
    public static final int TYPE_UNSEEN = 16;
    public static final int TYPE_BCC = 17;
    public static final int TYPE_BODY = 18;
    public static final int TYPE_CC = 19;
    public static final int TYPE_FROM = 20;
    public static final int TYPE_KEYWORD = 21;
    public static final int TYPE_SUBJECT = 22;
    public static final int TYPE_TEXT = 23;
    public static final int TYPE_TO = 24;
    public static final int TYPE_UNKEYWORD = 25;
    public static final int TYPE_BEFORE = 26;
    public static final int TYPE_ON = 27;
    public static final int TYPE_SENTBEFORE = 28;
    public static final int TYPE_SENTON = 29;
    public static final int TYPE_SENTSINCE = 30;
    public static final int TYPE_SINCE = 31;
    public static final int TYPE_HEADER = 32;
    public static final int TYPE_LARGER = 33;
    public static final int TYPE_SMALLER = 34;
    public static final int TYPE_NOT = 35;
    public static final int TYPE_OR = 36;
    public static final int TYPE_AND = 37;
    public static final int TYPE_YOUNGER = 38;
    public static final int TYPE_OLDER = 39;
    public static final int TYPE_MODSEQ = 40;
    private static final SearchKey UNSEEN = new SearchKey(16, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey UNFLAGGED = new SearchKey(15, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey UNDRAFT = new SearchKey(14, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey UNDELETED = new SearchKey(13, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey UNANSWERED = new SearchKey(12, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey SEEN = new SearchKey(11, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey RECENT = new SearchKey(10, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey OLD = new SearchKey(9, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey NEW = new SearchKey(8, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey FLAGGED = new SearchKey(7, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey DRAFT = new SearchKey(6, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey DELETED = new SearchKey(5, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey ANSWERED = new SearchKey(4, null, null, 0L, null, null, null, null, -1L, -1L);
    private static final SearchKey ALL = new SearchKey(3, null, null, 0L, null, null, null, null, -1L, -1L);
    private final int type;
    private final DayMonthYear date;
    private final List<SearchKey> keys;
    private final long size;
    private final String name;
    private final String value;
    private final IdRange[] sequence;
    private final UidRange[] uids;
    private final long seconds;
    private final long modSeq;

    public static SearchKey buildSequenceSet(IdRange[] ids) {
        return new SearchKey(1, null, null, 0L, null, null, null, ids, -1L, -1L);
    }

    public static SearchKey buildUidSet(UidRange[] ids) {
        return new SearchKey(2, null, null, 0L, null, null, ids, null, -1L, -1L);
    }

    public static SearchKey buildAll() {
        return ALL;
    }

    public static SearchKey buildAnswered() {
        return ANSWERED;
    }

    public static SearchKey buildDeleted() {
        return DELETED;
    }

    public static SearchKey buildDraft() {
        return DRAFT;
    }

    public static SearchKey buildFlagged() {
        return FLAGGED;
    }

    public static SearchKey buildNew() {
        return NEW;
    }

    public static SearchKey buildOld() {
        return OLD;
    }

    public static SearchKey buildRecent() {
        return RECENT;
    }

    public static SearchKey buildSeen() {
        return SEEN;
    }

    public static SearchKey buildUnanswered() {
        return UNANSWERED;
    }

    public static SearchKey buildUndeleted() {
        return UNDELETED;
    }

    public static SearchKey buildUndraft() {
        return UNDRAFT;
    }

    public static SearchKey buildUnflagged() {
        return UNFLAGGED;
    }

    public static SearchKey buildUnseen() {
        return UNSEEN;
    }

    public static SearchKey buildBcc(String value) {
        return new SearchKey(17, null, null, 0L, null, value, null, null, -1L, -1L);
    }

    public static SearchKey buildBody(String value) {
        return new SearchKey(18, null, null, 0L, null, value, null, null, -1L, -1L);
    }

    public static SearchKey buildCc(String value) {
        return new SearchKey(19, null, null, 0L, null, value, null, null, -1L, -1L);
    }

    public static SearchKey buildFrom(String value) {
        return new SearchKey(20, null, null, 0L, null, value, null, null, -1L, -1L);
    }

    public static SearchKey buildKeyword(String value) {
        return new SearchKey(21, null, null, 0L, null, value, null, null, -1L, -1L);
    }

    public static SearchKey buildSubject(String value) {
        return new SearchKey(22, null, null, 0L, null, value, null, null, -1L, -1L);
    }

    public static SearchKey buildText(String value) {
        return new SearchKey(23, null, null, 0L, null, value, null, null, -1L, -1L);
    }

    public static SearchKey buildTo(String value) {
        return new SearchKey(24, null, null, 0L, null, value, null, null, -1L, -1L);
    }

    public static SearchKey buildUnkeyword(String value) {
        return new SearchKey(25, null, null, 0L, null, value, null, null, -1L, -1L);
    }

    public static SearchKey buildYounger(long seconds) {
        return new SearchKey(38, null, null, 0L, null, null, null, null, seconds, -1L);
    }

    public static SearchKey buildOlder(long seconds) {
        return new SearchKey(39, null, null, 0L, null, null, null, null, seconds, -1L);
    }

    public static SearchKey buildBefore(DayMonthYear date) {
        return new SearchKey(26, date, null, 0L, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildOn(DayMonthYear date) {
        return new SearchKey(27, date, null, 0L, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildSentBefore(DayMonthYear date) {
        return new SearchKey(28, date, null, 0L, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildSentOn(DayMonthYear date) {
        return new SearchKey(29, date, null, 0L, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildSentSince(DayMonthYear date) {
        return new SearchKey(30, date, null, 0L, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildSince(DayMonthYear date) {
        return new SearchKey(31, date, null, 0L, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildHeader(String name, String value) {
        return new SearchKey(32, null, null, 0L, name, value, null, null, -1L, -1L);
    }

    public static SearchKey buildLarger(long size) {
        return new SearchKey(33, null, null, size, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildSmaller(long size) {
        return new SearchKey(34, null, null, size, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildNot(SearchKey key) {
        ArrayList<SearchKey> keys = new ArrayList<SearchKey>();
        keys.add(key);
        return new SearchKey(35, null, keys, 0L, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildOr(SearchKey keyOne, SearchKey keyTwo) {
        ArrayList<SearchKey> keys = new ArrayList<SearchKey>();
        keys.add(keyOne);
        keys.add(keyTwo);
        return new SearchKey(36, null, keys, 0L, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildAnd(List<SearchKey> keys) {
        return new SearchKey(37, null, keys, 0L, null, null, null, null, -1L, -1L);
    }

    public static SearchKey buildModSeq(long modSeq) {
        return new SearchKey(4, null, null, 0L, null, null, null, null, -1L, modSeq);
    }

    private SearchKey(int type, DayMonthYear date, List<SearchKey> keys, long number, String name, String value, UidRange[] uids, IdRange[] sequence, long seconds, long modSeq) {
        this.type = type;
        this.date = date;
        this.keys = keys;
        this.size = number;
        this.name = name;
        this.value = value;
        this.seconds = seconds;
        this.modSeq = modSeq;
        this.uids = uids;
        this.sequence = sequence;
    }

    public DayMonthYear getDate() {
        return this.date;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public IdRange[] getSequenceNumbers() {
        return this.sequence;
    }

    public UidRange[] getUidRanges() {
        return this.uids;
    }

    public String getName() {
        return this.name;
    }

    public long getSize() {
        return this.size;
    }

    public List<SearchKey> getKeys() {
        return this.keys;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public long getModSeq() {
        return this.modSeq;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        if (this.sequence != null) {
            result = 31 * result + this.sequence.length;
        }
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        result = 31 * result + this.type;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchKey other = (SearchKey)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (!Arrays.equals(this.sequence, other.sequence)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.keys == null ? other.keys != null : !this.keys.equals(other.keys)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

