/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.api;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class ImapConfiguration {
    public static final boolean DEFAULT_ENABLE_IDLE = true;
    public static final long DEFAULT_HEARTBEAT_INTERVAL_IN_SECONDS = 120L;
    public static final TimeUnit DEFAULT_HEARTBEAT_INTERVAL_UNIT = TimeUnit.SECONDS;
    private final long idleTimeInterval;
    private final TimeUnit idleTimeIntervalUnit;
    private final ImmutableSet<String> disabledCaps;
    private final boolean enableIdle;
    private final boolean isCondstoreEnable;

    public static Builder builder() {
        return new Builder();
    }

    private ImapConfiguration(boolean enableIdle, long idleTimeInterval, TimeUnit idleTimeIntervalUnit, ImmutableSet<String> disabledCaps, boolean isCondstoreEnable) {
        this.enableIdle = enableIdle;
        this.idleTimeInterval = idleTimeInterval;
        this.idleTimeIntervalUnit = idleTimeIntervalUnit;
        this.disabledCaps = disabledCaps;
        this.isCondstoreEnable = isCondstoreEnable;
    }

    public long getIdleTimeInterval() {
        return this.idleTimeInterval;
    }

    public TimeUnit getIdleTimeIntervalUnit() {
        return this.idleTimeIntervalUnit;
    }

    public ImmutableSet<String> getDisabledCaps() {
        return this.disabledCaps;
    }

    public boolean isEnableIdle() {
        return this.enableIdle;
    }

    public boolean isCondstoreEnable() {
        return this.isCondstoreEnable;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof ImapConfiguration) {
            ImapConfiguration that = (ImapConfiguration)obj;
            return Objects.equal((Object)that.isEnableIdle(), (Object)this.enableIdle) && Objects.equal((Object)that.getIdleTimeInterval(), (Object)this.idleTimeInterval) && Objects.equal((Object)((Object)that.getIdleTimeIntervalUnit()), (Object)((Object)this.idleTimeIntervalUnit)) && Objects.equal(that.getDisabledCaps(), this.disabledCaps) && Objects.equal((Object)that.isCondstoreEnable(), (Object)this.isCondstoreEnable);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.enableIdle, this.idleTimeInterval, this.idleTimeIntervalUnit, this.disabledCaps, this.isCondstoreEnable});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("enabledIdle", this.enableIdle).add("idleTimeInterval", this.idleTimeInterval).add("idleTimeIntervalUnit", (Object)this.idleTimeIntervalUnit).add("disabledCaps", this.disabledCaps).add("isCondstoreEnable", this.isCondstoreEnable).toString();
    }

    public static class Builder {
        private static final Function<String, String> NORMALIZE_STRING = new Function<String, String>(){

            public String apply(String disableCap) {
                return StringUtils.normalizeSpace((String)disableCap);
            }
        };
        private static final Predicate<String> NO_BLANK = new Predicate<String>(){

            public boolean apply(String disableCap) {
                return Builder.noBlankString(disableCap);
            }
        };
        private static final boolean DEFAULT_CONDSTORE_DISABLE = false;
        private Optional<Long> idleTimeInterval = Optional.absent();
        private Optional<TimeUnit> idleTimeIntervalUnit = Optional.absent();
        private Optional<Boolean> enableIdle = Optional.absent();
        private ImmutableSet<String> disabledCaps = ImmutableSet.of();
        private Optional<Boolean> isCondstoreEnable = Optional.absent();

        private static boolean noBlankString(String disableCap) {
            return !StringUtils.isBlank((String)disableCap);
        }

        private Builder() {
        }

        public Builder idleTimeInterval(long idleTimeInterval) {
            Preconditions.checkArgument((idleTimeInterval > 0L ? 1 : 0) != 0, (Object)"The interval time should not be rezo or negative");
            this.idleTimeInterval = Optional.of((Object)idleTimeInterval);
            return this;
        }

        public Builder idleTimeIntervalUnit(TimeUnit idleTimeIntervalUnit) {
            this.idleTimeIntervalUnit = Optional.of((Object)((Object)idleTimeIntervalUnit));
            return this;
        }

        public Builder enableIdle(Boolean enableIdle) {
            this.enableIdle = Optional.of((Object)enableIdle);
            return this;
        }

        public Builder disabledCaps(ImmutableSet<String> disabledCaps) {
            this.disabledCaps = disabledCaps;
            return this;
        }

        public Builder disabledCaps(String ... disableCaps) {
            this.disabledCaps = ImmutableSet.copyOf((Object[])disableCaps);
            return this;
        }

        public Builder disabledCap(String disableCap) {
            this.disabledCaps = ImmutableSet.of((Object)disableCap);
            return this;
        }

        public Builder isCondstoreEnable(boolean isCondstoreEnable) {
            this.isCondstoreEnable = Optional.of((Object)isCondstoreEnable);
            return this;
        }

        public ImapConfiguration build() {
            ImmutableSet normalizeDisableCaps = FluentIterable.from(this.disabledCaps).filter(NO_BLANK).transform(NORMALIZE_STRING).toSet();
            return new ImapConfiguration((Boolean)this.enableIdle.or((Object)true), (Long)this.idleTimeInterval.or((Object)120L), (TimeUnit)((Object)this.idleTimeIntervalUnit.or((Object)DEFAULT_HEARTBEAT_INTERVAL_UNIT)), normalizeDisableCaps, (Boolean)this.isCondstoreEnable.or((Object)false));
        }
    }
}

