/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox.maildir;

import java.io.FileNotFoundException;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.mailbox.MailboxPathLocker;
import org.apache.james.mailbox.maildir.MaildirStore;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;

public class MaildirStoreUtil {
    public static MaildirStore create(FileSystem fs, UsersRepository usersRepos, String rootURL, MailboxPathLocker locker) throws FileNotFoundException, UsersRepositoryException {
        StringBuilder root = new StringBuilder();
        root.append(fs.getFile(rootURL).getAbsolutePath());
        if (usersRepos.supportVirtualHosting()) {
            root.append("/").append("%domain").append("/").append("%user").append("/");
        } else {
            root.append("/").append("%user").append("/");
        }
        return new MaildirStore(root.toString(), locker);
    }
}

