/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import javax.inject.Inject;
import org.apache.james.adapter.mailbox.QuotaManagementMBean;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.quota.MaxQuotaManager;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.mailbox.store.mail.model.SerializableQuota;

public class QuotaManagement
implements QuotaManagementMBean {
    private final QuotaManager quotaManager;
    private final MaxQuotaManager maxQuotaManager;
    private final QuotaRootResolver quotaRootResolver;

    @Inject
    public QuotaManagement(QuotaManager quotaManager, MaxQuotaManager maxQuotaManager, QuotaRootResolver quotaRootResolver) {
        this.quotaManager = quotaManager;
        this.maxQuotaManager = maxQuotaManager;
        this.quotaRootResolver = quotaRootResolver;
    }

    @Override
    public String getQuotaRoot(String namespace, String user, String name) throws MailboxException {
        return this.quotaRootResolver.getQuotaRoot(new MailboxPath(namespace, user, name)).getValue();
    }

    @Override
    public long getMaxMessageCount(String quotaRoot) throws MailboxException {
        return this.maxQuotaManager.getMaxMessage(this.quotaRootResolver.createQuotaRoot(quotaRoot));
    }

    @Override
    public long getMaxStorage(String quotaRoot) throws MailboxException {
        return this.maxQuotaManager.getMaxStorage(this.quotaRootResolver.createQuotaRoot(quotaRoot));
    }

    @Override
    public long getDefaultMaxMessageCount() throws MailboxException {
        return this.maxQuotaManager.getDefaultMaxMessage();
    }

    @Override
    public long getDefaultMaxStorage() throws MailboxException {
        return this.maxQuotaManager.getDefaultMaxStorage();
    }

    @Override
    public void setMaxMessageCount(String quotaRoot, long maxMessageCount) throws MailboxException {
        this.maxQuotaManager.setMaxMessage(this.quotaRootResolver.createQuotaRoot(quotaRoot), maxMessageCount);
    }

    @Override
    public void setMaxStorage(String quotaRoot, long maxSize) throws MailboxException {
        this.maxQuotaManager.setMaxStorage(this.quotaRootResolver.createQuotaRoot(quotaRoot), maxSize);
    }

    @Override
    public void setDefaultMaxMessageCount(long maxDefaultMessageCount) throws MailboxException {
        this.maxQuotaManager.setDefaultMaxMessage(maxDefaultMessageCount);
    }

    @Override
    public void setDefaultMaxStorage(long maxDefaultSize) throws MailboxException {
        this.maxQuotaManager.setDefaultMaxStorage(maxDefaultSize);
    }

    @Override
    public SerializableQuota getMessageCountQuota(String quotaRoot) throws MailboxException {
        return new SerializableQuota(this.quotaManager.getMessageQuota(this.quotaRootResolver.createQuotaRoot(quotaRoot)));
    }

    @Override
    public SerializableQuota getStorageQuota(String quotaRoot) throws MailboxException {
        return new SerializableQuota(this.quotaManager.getStorageQuota(this.quotaRootResolver.createQuotaRoot(quotaRoot)));
    }
}

