/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.adapter.mailbox.MailboxManagerManagementMBean;
import org.apache.james.lifecycle.api.LogEnabled;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.MailboxQuery;
import org.slf4j.Logger;

public class MailboxManagerManagement
extends StandardMBean
implements MailboxManagerManagementMBean,
LogEnabled {
    private MailboxManager mailboxManager;
    private Logger log;

    @Inject
    public void setMailboxManager(@Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public MailboxManagerManagement() throws NotCompliantMBeanException {
        super(MailboxManagerManagementMBean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteMailboxes(String username) {
        this.checkString(username, "Username");
        MailboxSession session = null;
        try {
            session = this.mailboxManager.createSystemSession(username, this.log);
            this.mailboxManager.startProcessingRequest(session);
            List<MailboxMetaData> mList = this.retrieveAllUserMailboxes(username, session);
            for (MailboxMetaData aMList : mList) {
                this.mailboxManager.deleteMailbox(aMList.getPath(), session);
            }
            boolean bl = true;
            this.closeSession(session);
            return bl;
        }
        catch (MailboxException e) {
            try {
                this.log.error("Error while remove mailboxes for user " + username, (Throwable)e);
                this.closeSession(session);
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        return false;
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listMailboxes(String username) {
        this.checkString(username, "Username");
        ArrayList<String> boxes = new ArrayList<String>();
        MailboxSession session = null;
        try {
            session = this.mailboxManager.createSystemSession(username, this.log);
            this.mailboxManager.startProcessingRequest(session);
            List<MailboxMetaData> mList = this.retrieveAllUserMailboxes(username, session);
            for (MailboxMetaData aMList : mList) {
                boxes.add(aMList.getPath().getName());
            }
            Collections.sort(boxes);
            this.closeSession(session);
        }
        catch (MailboxException e) {
            try {
                this.log.error("Error list mailboxes for user " + username, (Throwable)e);
                this.closeSession(session);
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        return boxes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createMailbox(String namespace, String user, String name) {
        this.checkMailboxArguments(namespace, user, name);
        MailboxSession session = null;
        try {
            session = this.mailboxManager.createSystemSession(user, this.log);
            this.mailboxManager.startProcessingRequest(session);
            this.mailboxManager.createMailbox(new MailboxPath(namespace, user, name), session);
            this.closeSession(session);
        }
        catch (Exception e) {
            try {
                this.log.error("Unable to create mailbox", (Throwable)e);
                this.closeSession(session);
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMailbox(String namespace, String user, String name) {
        this.checkMailboxArguments(namespace, user, name);
        MailboxSession session = null;
        try {
            session = this.mailboxManager.createSystemSession(user, this.log);
            this.mailboxManager.startProcessingRequest(session);
            this.mailboxManager.deleteMailbox(new MailboxPath(namespace, user, name), session);
            this.closeSession(session);
        }
        catch (Exception e) {
            try {
                this.log.error("Unable to create mailbox", (Throwable)e);
                this.closeSession(session);
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
    }

    private void closeSession(MailboxSession session) {
        if (session != null) {
            this.mailboxManager.endProcessingRequest(session);
            try {
                this.mailboxManager.logout(session, true);
            }
            catch (MailboxException e) {
                this.log.error("Can not log session out", (Throwable)e);
            }
        }
    }

    private List<MailboxMetaData> retrieveAllUserMailboxes(String username, MailboxSession session) throws MailboxException {
        return this.mailboxManager.search(new MailboxQuery(new MailboxPath("#private", username, ""), "*", session.getPathDelimiter()), session);
    }

    private void checkMailboxArguments(String namespace, String user, String name) {
        this.checkString(namespace, "mailbox path namespace");
        this.checkString(user, "mailbox path user");
        this.checkString(name, "mailbox name");
    }

    private void checkString(String argument, String role) {
        Preconditions.checkNotNull((Object)argument, (Object)("Provided " + role + " should not be null."));
        Preconditions.checkArgument((!argument.equals("") ? 1 : 0) != 0, (Object)("Provided " + role + " should not be empty."));
    }
}

