/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.james.system.hbase.TablePool;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.hbase.def.HUsersRepository;
import org.apache.james.user.lib.AbstractUsersRepository;
import org.apache.james.user.lib.model.DefaultUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseUsersRepository
extends AbstractUsersRepository {
    private static final Logger log = LoggerFactory.getLogger((String)HBaseUsersRepository.class.getName());
    private String algo;

    public void doConfigure(HierarchicalConfiguration config) throws ConfigurationException {
        this.algo = config.getString("algorithm", "MD5");
        super.doConfigure(config);
    }

    public User getUserByName(String name) throws UsersRepositoryException {
        KeyValue keyValue = this.getKeyValue(name);
        DefaultUser user = null;
        if (keyValue != null) {
            user = new DefaultUser(Bytes.toString((byte[])keyValue.getRow()), Bytes.toString((byte[])keyValue.getValue()), this.algo);
        }
        return user;
    }

    public void updateUser(User user) throws UsersRepositoryException {
        if (user == null) {
            throw new UsersRepositoryException("Please provide a non null user");
        }
        if (!(user instanceof DefaultUser)) {
            throw new UsersRepositoryException("Please provide a user instanceof DefaultUser");
        }
        User existingUser = this.getUserByName(user.getUserName());
        if (existingUser == null) {
            throw new UsersRepositoryException("Please provide an existing user to update");
        }
        this.putUser((DefaultUser)user, false);
    }

    public void removeUser(String name) throws UsersRepositoryException {
        HTableInterface table = null;
        try {
            table = TablePool.getInstance().getUsersRepositoryTable();
            Delete delete = new Delete(Bytes.toBytes((String)name));
            table.delete(delete);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while deleting user from HBase", (Throwable)e);
            throw new UsersRepositoryException("Error while deleting user from HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean contains(String name) throws UsersRepositoryException {
        KeyValue keyValue = this.getKeyValue(name.toLowerCase(Locale.US));
        return keyValue != null;
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        KeyValue keyValue = this.getKeyValue(name);
        if (keyValue != null) {
            DefaultUser user = new DefaultUser(name, this.algo);
            user.setPassword(password);
            return Bytes.toString((byte[])keyValue.getValue()).equals(user.getHashedPassword());
        }
        return false;
    }

    public int countUsers() throws UsersRepositoryException {
        HTableInterface table = null;
        ResultScanner resultScanner = null;
        try {
            table = TablePool.getInstance().getUsersRepositoryTable();
            Scan scan = new Scan();
            scan.addFamily(HUsersRepository.COLUMN_FAMILY_NAME);
            scan.setCaching(table.getConfiguration().getInt("hbase.client.scanner.caching", 1) * 2);
            resultScanner = table.getScanner(scan);
            int resultCount = 0;
            while (resultScanner.next() != null) {
                ++resultCount;
            }
            int n = resultCount;
            return n;
        }
        catch (IOException e) {
            log.error("Error while counting users from HBase", (Throwable)e);
            throw new UsersRepositoryException("Error while counting users from HBase", (Throwable)e);
        }
        finally {
            if (resultScanner != null) {
                resultScanner.close();
            }
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Iterator<String> list() throws UsersRepositoryException {
        ArrayList<String> list = new ArrayList<String>();
        HTableInterface table = null;
        ResultScanner resultScanner = null;
        try {
            Result result;
            table = TablePool.getInstance().getUsersRepositoryTable();
            Scan scan = new Scan();
            scan.addFamily(HUsersRepository.COLUMN_FAMILY_NAME);
            scan.setCaching(table.getConfiguration().getInt("hbase.client.scanner.caching", 1) * 2);
            resultScanner = table.getScanner(scan);
            while ((result = resultScanner.next()) != null) {
                list.add(Bytes.toString((byte[])result.getRow()));
            }
        }
        catch (IOException e) {
            log.error("Error while scanning users from HBase", (Throwable)e);
            throw new UsersRepositoryException("Error while scanning users from HBase", (Throwable)e);
        }
        finally {
            if (resultScanner != null) {
                resultScanner.close();
            }
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list.iterator();
    }

    protected void doAddUser(String username, String password) throws UsersRepositoryException {
        DefaultUser user = new DefaultUser(username, this.algo);
        user.setPassword(password);
        this.putUser(user, true);
    }

    private KeyValue getKeyValue(String username) throws UsersRepositoryException {
        HTableInterface table = null;
        try {
            KeyValue keyValue;
            table = TablePool.getInstance().getUsersRepositoryTable();
            Get get = new Get(Bytes.toBytes((String)username));
            Result result = table.get(get);
            KeyValue keyValue2 = keyValue = result.getColumnLatest(HUsersRepository.COLUMN_FAMILY_NAME, HUsersRepository.COLUMN.PWD);
            return keyValue2;
        }
        catch (IOException e) {
            log.error("Error while counting users from HBase", (Throwable)e);
            throw new UsersRepositoryException("Error while counting users from HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void putUser(DefaultUser user, boolean isAdd) throws UsersRepositoryException {
        String username = user.getUserName();
        if (isAdd && this.contains(username = user.getUserName().toLowerCase(Locale.US))) {
            throw new UsersRepositoryException(username + " already exists.");
        }
        HTableInterface table = null;
        try {
            table = TablePool.getInstance().getUsersRepositoryTable();
            Put put = new Put(Bytes.toBytes((String)username));
            put.add(HUsersRepository.COLUMN_FAMILY_NAME, HUsersRepository.COLUMN.PWD, Bytes.toBytes((String)user.getHashedPassword()));
            table.put(put);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while adding user in HBase", (Throwable)e);
            throw new UsersRepositoryException("Error while adding user in HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

