/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.hbase;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.hbase.def.HRecipientRewriteTable;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;
import org.apache.james.system.hbase.TablePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private static final Logger log = LoggerFactory.getLogger((String)HBaseRecipientRewriteTable.class.getName());
    private static final String ROW_SEPARATOR = "@";

    protected void addMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        String fixedDomain;
        String fixedUser = this.getFixedUser(user);
        Mappings map = this.getUserDomainMappings(fixedUser, fixedDomain = this.getFixedDomain(domain));
        if (map != null && map.size() != 0) {
            MappingsImpl updatedMappings = MappingsImpl.from((Mappings)map).add(mapping).build();
            this.doUpdateMapping(fixedUser, fixedDomain, updatedMappings.serialize());
        } else {
            this.doAddMapping(fixedUser, fixedDomain, mapping);
        }
    }

    protected Mappings getUserDomainMappingsInternal(String user, String domain) throws RecipientRewriteTableException {
        HTableInterface table = null;
        MappingsImpl list = MappingsImpl.empty();
        try {
            table = TablePool.getInstance().getRecipientRewriteTable();
            Mappings mappings = this.feedUserDomainMappingsList(table, user, domain, (Mappings)list);
            return mappings;
        }
        catch (IOException e) {
            log.error("Error while getting user domain mapping in HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while getting user domain mapping in HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Mappings feedUserDomainMappingsList(HTableInterface table, String user, String domain, Mappings list) throws IOException {
        Get get = new Get(Bytes.toBytes((String)this.getRowKey(user, domain)));
        Result result = table.get(get);
        List keyValues = result.getColumn(HRecipientRewriteTable.COLUMN_FAMILY_NAME, HRecipientRewriteTable.COLUMN.MAPPING);
        if (keyValues.size() > 0) {
            return MappingsImpl.from((Mappings)list).addAll((Mappings)MappingsImpl.fromRawString((String)Bytes.toString((byte[])((KeyValue)keyValues.get(0)).getValue()))).build();
        }
        return list;
    }

    protected Map<String, Mappings> getAllMappingsInternal() throws RecipientRewriteTableException {
        HTableInterface table = null;
        ResultScanner resultScanner = null;
        HashMap<String, MappingsImpl> map = null;
        try {
            Result result;
            table = TablePool.getInstance().getRecipientRewriteTable();
            Scan scan = new Scan();
            scan.addFamily(HRecipientRewriteTable.COLUMN_FAMILY_NAME);
            scan.setCaching(table.getConfiguration().getInt("hbase.client.scanner.caching", 1) * 2);
            resultScanner = table.getScanner(scan);
            while ((result = resultScanner.next()) != null) {
                List keyValues = result.list();
                if (keyValues == null) continue;
                for (KeyValue keyValue : keyValues) {
                    String email = Bytes.toString((byte[])keyValue.getRow());
                    if (map == null) {
                        map = new HashMap<String, MappingsImpl>();
                    }
                    MappingsImpl mappings = MappingsImpl.from((Mappings)((Mappings)Optional.fromNullable(map.get(email)).or((Object)MappingsImpl.empty()))).add(Bytes.toString((byte[])keyValue.getRow())).build();
                    map.put(email, mappings);
                }
            }
        }
        catch (IOException e) {
            log.error("Error while getting all mapping from HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while getting all mappings from HBase", (Throwable)e);
        }
        finally {
            if (resultScanner != null) {
                resultScanner.close();
            }
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
        return map;
    }

    protected String mapAddressInternal(String user, String domain) throws RecipientRewriteTableException {
        HTableInterface table = null;
        String mappings = null;
        try {
            table = TablePool.getInstance().getRecipientRewriteTable();
            mappings = this.getMapping(table, user, domain);
            if (mappings == null) {
                mappings = this.getMapping(table, "*", domain);
            }
            if (mappings == null) {
                mappings = this.getMapping(table, user, "*");
            }
        }
        catch (IOException e) {
            log.error("Error while mapping address in HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while mapping address in HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
        return mappings;
    }

    private String getMapping(HTableInterface table, String user, String domain) throws IOException {
        Get get = new Get(Bytes.toBytes((String)this.getRowKey(user, domain)));
        Result result = table.get(get);
        List keyValues = result.getColumn(HRecipientRewriteTable.COLUMN_FAMILY_NAME, HRecipientRewriteTable.COLUMN.MAPPING);
        if (keyValues.size() > 0) {
            return Bytes.toString((byte[])((KeyValue)keyValues.get(0)).getValue());
        }
        return null;
    }

    protected void removeMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        String fixedDomain;
        String fixedUser = this.getFixedUser(user);
        Mappings map = this.getUserDomainMappings(fixedUser, fixedDomain = this.getFixedDomain(domain));
        if (map != null && map.size() > 1) {
            Mappings updatedMappings = map.remove(mapping);
            this.doUpdateMapping(fixedUser, fixedDomain, updatedMappings.serialize());
        } else {
            this.doRemoveMapping(fixedUser, fixedDomain, mapping);
        }
    }

    private void doUpdateMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        this.doAddMapping(user, domain, mapping);
    }

    private void doRemoveMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        HTableInterface table = null;
        try {
            table = TablePool.getInstance().getRecipientRewriteTable();
            Delete delete = new Delete(Bytes.toBytes((String)this.getRowKey(user, domain)));
            table.delete(delete);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while removing mapping from HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while removing mapping from HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void doAddMapping(String user, String domain, String mapping) throws RecipientRewriteTableException {
        HTableInterface table = null;
        try {
            table = TablePool.getInstance().getRecipientRewriteTable();
            Put put = new Put(Bytes.toBytes((String)this.getRowKey(user, domain)));
            put.add(HRecipientRewriteTable.COLUMN_FAMILY_NAME, HRecipientRewriteTable.COLUMN.MAPPING, Bytes.toBytes((String)mapping));
            table.put(put);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while adding mapping in HBase", (Throwable)e);
            throw new RecipientRewriteTableException("Error while adding mapping in HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String getRowKey(String user, String domain) {
        return user + ROW_SEPARATOR + domain;
    }
}

