/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.hbase.def.HDomainList;
import org.apache.james.domainlist.lib.AbstractDomainList;
import org.apache.james.system.hbase.TablePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseDomainList
extends AbstractDomainList {
    private static final Logger log = LoggerFactory.getLogger((String)HBaseDomainList.class.getName());

    public boolean containsDomain(String domain) throws DomainListException {
        HTableInterface table = null;
        try {
            table = TablePool.getInstance().getDomainlistTable();
            Get get = new Get(Bytes.toBytes((String)domain.toLowerCase(Locale.US)));
            Result result = table.get(get);
            if (!result.isEmpty()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            log.error("Error while counting domains from HBase", (Throwable)e);
            throw new DomainListException("Error while counting domains from HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public void addDomain(String domain) throws DomainListException {
        String lowerCasedDomain = domain.toLowerCase(Locale.US);
        if (this.containsDomain(lowerCasedDomain)) {
            throw new DomainListException(lowerCasedDomain + " already exists.");
        }
        HTableInterface table = null;
        try {
            table = TablePool.getInstance().getDomainlistTable();
            Put put = new Put(Bytes.toBytes((String)lowerCasedDomain));
            put.add(HDomainList.COLUMN_FAMILY_NAME, HDomainList.COLUMN.DOMAIN, null);
            table.put(put);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while adding domain in HBase", (Throwable)e);
            throw new DomainListException("Error while adding domain in HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void removeDomain(String domain) throws DomainListException {
        HTableInterface table = null;
        try {
            table = TablePool.getInstance().getDomainlistTable();
            Delete delete = new Delete(Bytes.toBytes((String)domain.toLowerCase(Locale.US)));
            table.delete(delete);
            table.flushCommits();
        }
        catch (IOException e) {
            log.error("Error while deleting user from HBase", (Throwable)e);
            throw new DomainListException("Error while deleting domain from HBase", (Throwable)e);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected List<String> getDomainListInternal() throws DomainListException {
        ArrayList<String> list = new ArrayList<String>();
        HTableInterface table = null;
        ResultScanner resultScanner = null;
        try {
            Result result;
            table = TablePool.getInstance().getDomainlistTable();
            Scan scan = new Scan();
            scan.addFamily(HDomainList.COLUMN_FAMILY_NAME);
            scan.setCaching(table.getConfiguration().getInt("hbase.client.scanner.caching", 1) * 2);
            resultScanner = table.getScanner(scan);
            while ((result = resultScanner.next()) != null) {
                list.add(Bytes.toString((byte[])result.getRow()));
            }
        }
        catch (IOException e) {
            log.error("Error while counting domains from HBase", (Throwable)e);
            throw new DomainListException("Error while counting domains from HBase", (Throwable)e);
        }
        finally {
            if (resultScanner != null) {
                resultScanner.close();
            }
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }
}

