/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import com.google.common.base.Optional;
import javax.mail.MessagingException;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class ReplyToUtils {
    private final Optional<MailAddress> replyTo;

    public static ReplyToUtils from(Optional<MailAddress> replyTo) {
        return new ReplyToUtils(replyTo);
    }

    public static ReplyToUtils from(MailAddress replyTo) {
        return new ReplyToUtils((Optional<MailAddress>)Optional.fromNullable((Object)replyTo));
    }

    private ReplyToUtils(Optional<MailAddress> replyTo) {
        this.replyTo = replyTo;
    }

    public Optional<MailAddress> getReplyTo(Mail originalMail) throws MessagingException {
        if (this.replyTo.isPresent()) {
            if (((MailAddress)this.replyTo.get()).equals((Object)SpecialAddress.UNALTERED)) {
                return Optional.absent();
            }
            return Optional.fromNullable((Object)originalMail.getSender());
        }
        return Optional.absent();
    }
}

