/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.util;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.mailet.MailAddress;

public class MailAddressUtils {
    public static List<MailAddress> from(InternetAddress[] internetAddresses) throws AddressException {
        return MailAddressUtils.from((List<InternetAddress>)ImmutableList.copyOf((Object[])internetAddresses));
    }

    private static List<MailAddress> from(List<InternetAddress> internetAddresses) throws AddressException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (InternetAddress internetAddress : internetAddresses) {
            builder.add((Object)new MailAddress(internetAddress));
        }
        return builder.build();
    }

    public static List<InternetAddress> toInternetAddresses(List<MailAddress> mailAddresses) {
        return MailAddressUtils.iterableOfInternetAddress(mailAddresses).toList();
    }

    public static InternetAddress[] toInternetAddressArray(List<MailAddress> mailAddresses) {
        return (InternetAddress[])MailAddressUtils.iterableOfInternetAddress(mailAddresses).toArray(InternetAddress.class);
    }

    private static FluentIterable<InternetAddress> iterableOfInternetAddress(List<MailAddress> mailAddresses) {
        return FluentIterable.from(mailAddresses).transform((Function)new Function<MailAddress, InternetAddress>(){

            public InternetAddress apply(MailAddress mailAddress) {
                return mailAddress.toInternetAddress();
            }
        });
    }

    public static boolean isUnalteredOrReversePathOrSender(MailAddress mailAddress) {
        return mailAddress.equals((Object)SpecialAddress.UNALTERED) || mailAddress.equals((Object)SpecialAddress.REVERSE_PATH) || mailAddress.equals((Object)SpecialAddress.SENDER);
    }
}

