/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;
import org.apache.mailet.base.MailetUtil;

public class TooManyLines
extends GenericMatcher {
    private int maximumLineCount;

    public void init() throws MessagingException {
        this.maximumLineCount = MailetUtil.getInitParameterAsStrictlyPositiveInteger((String)this.getCondition());
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        if (mail.getMessage() == null) {
            return ImmutableList.of();
        }
        if (mail.getMessage().getLineCount() > this.maximumLineCount) {
            return ImmutableList.copyOf((Collection)mail.getRecipients());
        }
        return ImmutableList.of();
    }
}

