/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Set;
import javax.mail.MessagingException;
import org.apache.james.transport.matchers.utils.MailAddressCollectionReader;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

public class SenderIs
extends GenericMatcher {
    private Set<MailAddress> senders;

    @VisibleForTesting
    Set<MailAddress> getSenders() {
        return this.senders;
    }

    public void init() throws MessagingException {
        if (Strings.isNullOrEmpty((String)this.getCondition())) {
            throw new MessagingException("SenderIs should have at least one address as parameter");
        }
        this.senders = MailAddressCollectionReader.read((String)this.getCondition());
        if (this.senders.size() < 1) {
            throw new MessagingException("SenderIs should have at least one address as parameter");
        }
    }

    public Collection<MailAddress> match(Mail mail) {
        if (this.senders.contains(mail.getSender())) {
            return mail.getRecipients();
        }
        return null;
    }
}

