/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Locale;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

public class SenderHostIs
extends GenericMatcher {
    private Collection<String> senderHosts;

    public void init() {
        String condition = this.getCondition();
        Preconditions.checkNotNull((Object)condition, (Object)"'condition' should not be null");
        this.senderHosts = this.parseDomainsList(condition);
    }

    @VisibleForTesting
    Collection<String> parseDomainsList(String condition) {
        return ImmutableSet.copyOf((Iterable)Splitter.onPattern((String)"(, |,| )").omitEmptyStrings().split((CharSequence)condition));
    }

    public Collection<MailAddress> match(Mail mail) {
        try {
            if (mail.getSender() != null && this.senderHosts.contains(mail.getSender().getDomain().toLowerCase(Locale.US))) {
                return mail.getRecipients();
            }
        }
        catch (Exception e) {
            this.log(e.getMessage());
        }
        return null;
    }
}

