/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.QuotaRoot;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.QuotaRootResolver;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsOverQuota
extends GenericMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsOverQuota.class);
    private static final int SINGLE_EMAIL = 1;
    private final QuotaRootResolver quotaRootResolver;
    private final QuotaManager quotaManager;
    private final MailboxManager mailboxManager;
    private final UsersRepository usersRepository;

    @Inject
    public IsOverQuota(QuotaRootResolver quotaRootResolver, QuotaManager quotaManager, MailboxManager mailboxManager, UsersRepository usersRepository) {
        this.quotaRootResolver = quotaRootResolver;
        this.quotaManager = quotaManager;
        this.mailboxManager = mailboxManager;
        this.usersRepository = usersRepository;
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        try {
            ArrayList<MailAddress> result = new ArrayList<MailAddress>();
            for (MailAddress mailAddress : mail.getRecipients()) {
                String userName = this.usersRepository.getUser(mailAddress);
                MailboxSession mailboxSession = this.mailboxManager.createSystemSession(userName, LOGGER);
                MailboxPath mailboxPath = MailboxPath.inbox((MailboxSession)mailboxSession);
                QuotaRoot quotaRoot = this.quotaRootResolver.getQuotaRoot(mailboxPath);
                if (!this.quotaManager.getMessageQuota(quotaRoot).isOverQuotaWithAdditionalValue(1L) && !this.quotaManager.getStorageQuota(quotaRoot).isOverQuotaWithAdditionalValue(mail.getMessageSize())) continue;
                result.add(mailAddress);
            }
            return result;
        }
        catch (MailboxException e) {
            throw new MessagingException("Exception while checking quotas", (Exception)((Object)e));
        }
        catch (UsersRepositoryException e) {
            throw new MessagingException("Exception while retrieving username", (Exception)((Object)e));
        }
    }
}

