/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

@Experimental
public class InSpammerBlacklist
extends GenericMatcher {
    private String network = null;
    private DNSService dnsServer;

    @Inject
    public void setDNSService(DNSService dnsService) {
        this.dnsServer = dnsService;
    }

    public void init() throws MessagingException {
        this.network = this.getCondition();
        if (this.network == null) {
            throw new MessagingException("Please configure a blacklist");
        }
    }

    public Collection<MailAddress> match(Mail mail) {
        String host = mail.getRemoteAddr();
        try {
            StringBuilder sb = new StringBuilder();
            StringTokenizer st = new StringTokenizer(host, " .", false);
            while (st.hasMoreTokens()) {
                sb.insert(0, st.nextToken() + ".");
            }
            sb.append(this.network);
            this.dnsServer.getByName(sb.toString());
            return mail.getRecipients();
        }
        catch (UnknownHostException uhe) {
            return null;
        }
    }
}

