/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.io.Serializable;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.mail.MessagingException;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MatcherConfig;
import org.apache.mailet.base.GenericMatcher;

public class HasMailAttributeWithValueRegex
extends GenericMatcher {
    private String attributeName;
    private Pattern pattern = null;

    public String getMatcherInfo() {
        return "Has Mail Attribute Value Matcher";
    }

    public void init(MatcherConfig conf) throws MessagingException {
        String condition = conf.getCondition();
        int idx = condition.indexOf(44);
        if (idx != -1) {
            this.attributeName = condition.substring(0, idx).trim();
            String pattern_string = condition.substring(idx + 1, condition.length()).trim();
            try {
                this.pattern = Pattern.compile(pattern_string);
            }
            catch (PatternSyntaxException mpe) {
                throw new MessagingException("Malformed pattern: " + pattern_string, (Exception)mpe);
            }
        } else {
            throw new MessagingException("malformed condition for HasMailAttributeWithValueRegex. must be of the form: attr,regex");
        }
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Serializable obj = mail.getAttribute(this.attributeName);
        if (obj != null && this.pattern.matcher(obj.toString()).matches()) {
            return mail.getRecipients();
        }
        return null;
    }
}

