/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.util.MimeUtil;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

public class HasHeader
extends GenericMatcher {
    private static final String CONDITION_SEPARATOR = "+";
    private static final String HEADER_VALUE_SEPARATOR = "=";
    private List<HeaderCondition> headerConditions;

    private static String sanitizeHeaderField(String headerName) {
        return DecoderUtil.decodeEncodedWords((String)MimeUtil.unfold((String)headerName), (DecodeMonitor)DecodeMonitor.SILENT);
    }

    public void init() throws MessagingException {
        this.headerConditions = new ArrayList<HeaderCondition>();
        StringTokenizer conditionTokenizer = new StringTokenizer(this.getCondition(), CONDITION_SEPARATOR);
        while (conditionTokenizer.hasMoreTokens()) {
            this.headerConditions.add(this.parseHeaderCondition(conditionTokenizer.nextToken().trim()));
        }
    }

    private HeaderCondition parseHeaderCondition(String element) throws MessagingException {
        StringTokenizer valueSeparatorTokenizer = new StringTokenizer(element, HEADER_VALUE_SEPARATOR, false);
        if (!valueSeparatorTokenizer.hasMoreElements()) {
            throw new MessagingException("Missing headerName");
        }
        String headerName = valueSeparatorTokenizer.nextToken().trim();
        if (valueSeparatorTokenizer.hasMoreTokens()) {
            return new HeaderValueCondition(headerName, valueSeparatorTokenizer.nextToken().trim());
        }
        return new HeaderNameCondition(headerName);
    }

    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        for (HeaderCondition headerCondition : this.headerConditions) {
            if (headerCondition.isMatching(mail.getMessage())) continue;
            return null;
        }
        return mail.getRecipients();
    }

    private static class HeaderValueCondition
    implements HeaderCondition {
        private final String headerName;
        private final String headerValue;

        public HeaderValueCondition(String headerName, String headerValue) {
            this.headerName = headerName;
            this.headerValue = headerValue;
        }

        @Override
        public boolean isMatching(MimeMessage mimeMessage) throws MessagingException {
            String[] headerArray = mimeMessage.getHeader(this.headerName);
            if (headerArray != null && headerArray.length > 0) {
                for (String value : headerArray) {
                    if (!this.headerValue.equals(HasHeader.sanitizeHeaderField(value))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static class HeaderNameCondition
    implements HeaderCondition {
        private final String headerName;

        public HeaderNameCondition(String headerName) {
            this.headerName = headerName;
        }

        @Override
        public boolean isMatching(MimeMessage mimeMessage) throws MessagingException {
            String[] headerArray = mimeMessage.getHeader(this.headerName);
            return headerArray != null && headerArray.length > 0;
        }
    }

    private static interface HeaderCondition {
        public boolean isMatching(MimeMessage var1) throws MessagingException;
    }
}

