/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.matchers;

import com.google.common.base.Objects;
import java.util.Collection;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.GenericMatcher;

public class HasAttachment
extends GenericMatcher {
    public Collection<MailAddress> match(Mail mail) throws MessagingException {
        Throwable anException;
        block9: {
            anException = null;
            try {
                MimeMessage message = mail.getMessage();
                if (message.getContentType() == null) {
                    return null;
                }
                Object content = message.getContent();
                if (content instanceof Multipart) {
                    Multipart multipart = (Multipart)content;
                    for (int i = 0; i < multipart.getCount(); ++i) {
                        try {
                            BodyPart part = multipart.getBodyPart(i);
                            if (!this.isAttachment((Part)part)) continue;
                            return mail.getRecipients();
                        }
                        catch (MessagingException e) {
                            anException = e;
                        }
                    }
                    break block9;
                }
                if (this.isAttachment((Part)message)) {
                    return mail.getRecipients();
                }
            }
            catch (Exception e) {
                anException = e;
            }
        }
        if (anException != null) {
            throw new MessagingException("Malformed message", (Exception)anException);
        }
        return null;
    }

    private boolean isAttachment(Part part) throws MessagingException {
        return Objects.equal((Object)part.getDisposition(), (Object)"attachment");
    }
}

