/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remoteDelivery;

import com.sun.mail.smtp.SMTPTransport;
import java.io.IOException;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import org.apache.james.transport.mailets.remoteDelivery.Converter7Bit;
import org.apache.james.transport.mailets.remoteDelivery.ExecutionResult;
import org.apache.james.transport.mailets.remoteDelivery.RemoteDeliveryConfiguration;
import org.apache.mailet.HostAddress;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;

public class MailDelivrerToHost {
    public static final String BIT_MIME_8 = "8BITMIME";
    private final RemoteDeliveryConfiguration configuration;
    private final Converter7Bit converter7Bit;
    private final Session session;
    private final Logger logger;

    public MailDelivrerToHost(RemoteDeliveryConfiguration remoteDeliveryConfiguration, MailetContext mailetContext, Logger logger) {
        this.configuration = remoteDeliveryConfiguration;
        this.converter7Bit = new Converter7Bit(mailetContext);
        this.session = Session.getInstance((Properties)this.configuration.createFinalJavaxProperties());
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult tryDeliveryToHost(Mail mail, InternetAddress[] addr, HostAddress outgoingMailServer) throws MessagingException {
        Properties props = this.getPropertiesForMail(mail);
        this.logger.debug("Attempting delivery of {} to host {} at {} from {}", new Object[]{mail.getName(), outgoingMailServer.getHostName(), outgoingMailServer.getHost(), props.get("mail.smtp.from")});
        SMTPTransport transport = null;
        try {
            transport = (SMTPTransport)this.session.getTransport((URLName)outgoingMailServer);
            transport.setLocalHost(props.getProperty("mail.smtp.localhost", this.configuration.getHeloNameProvider().getHeloName()));
            this.connect(outgoingMailServer, transport);
            transport.sendMessage((Message)this.adaptToTransport(mail.getMessage(), transport), (Address[])addr);
            this.logger.debug("Mail ({})  sent successfully to {} at {} from {} for {}", new Object[]{mail.getName(), outgoingMailServer.getHostName(), outgoingMailServer.getHost(), props.get("mail.smtp.from"), mail.getRecipients()});
        }
        finally {
            this.closeTransport(mail, outgoingMailServer, transport);
        }
        return ExecutionResult.success();
    }

    private Properties getPropertiesForMail(Mail mail) {
        Properties props = this.session.getProperties();
        if (mail.getSender() == null) {
            props.put("mail.smtp.from", "<>");
        } else {
            String sender = mail.getSender().toString();
            props.put("mail.smtp.from", sender);
        }
        return props;
    }

    private void connect(HostAddress outgoingMailServer, SMTPTransport transport) throws MessagingException {
        if (this.configuration.getAuthUser() != null) {
            transport.connect(outgoingMailServer.getHostName(), this.configuration.getAuthUser(), this.configuration.getAuthPass());
        } else {
            transport.connect();
        }
    }

    private MimeMessage adaptToTransport(MimeMessage message, SMTPTransport transport) throws MessagingException {
        if (this.shouldAdapt(transport)) {
            try {
                this.converter7Bit.convertTo7Bit((MimePart)message);
            }
            catch (IOException e) {
                this.logger.error("Error during the conversion to 7 bit.", (Throwable)e);
            }
        }
        return message;
    }

    private boolean shouldAdapt(SMTPTransport transport) {
        return !transport.getClass().getName().endsWith(".SMTPTransport") || !transport.supportsExtension(BIT_MIME_8);
    }

    private void closeTransport(Mail mail, HostAddress outgoingMailServer, SMTPTransport transport) {
        if (transport != null) {
            try {
                transport.close();
            }
            catch (MessagingException e) {
                this.logger.error("Warning: could not close the SMTP transport after sending mail ({}) to {} at {} for {}; probably the server has already closed the connection. Message is considered to be delivered. Exception: {}", new Object[]{mail.getName(), outgoingMailServer.getHostName(), outgoingMailServer.getHost(), mail.getRecipients(), e.getMessage()});
            }
            transport = null;
        }
    }
}

