/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remoteDelivery;

import com.google.common.base.Objects;
import com.google.common.base.Optional;

public class ExecutionResult {
    private final ExecutionState executionState;
    private final Optional<Exception> exception;

    public static ExecutionResult success() {
        return new ExecutionResult(ExecutionState.SUCCESS, (Optional<Exception>)Optional.absent());
    }

    public static ExecutionResult temporaryFailure(Exception e) {
        return new ExecutionResult(ExecutionState.TEMPORARY_FAILURE, (Optional<Exception>)Optional.of((Object)e));
    }

    public static ExecutionResult permanentFailure(Exception e) {
        return new ExecutionResult(ExecutionState.PERMANENT_FAILURE, (Optional<Exception>)Optional.of((Object)e));
    }

    public static ExecutionResult temporaryFailure() {
        return new ExecutionResult(ExecutionState.TEMPORARY_FAILURE, (Optional<Exception>)Optional.absent());
    }

    public static ExecutionResult onFailure(boolean permanent, Exception exeption) {
        if (permanent) {
            return ExecutionResult.permanentFailure(exeption);
        }
        return ExecutionResult.temporaryFailure(exeption);
    }

    public ExecutionResult(ExecutionState executionState, Optional<Exception> exception) {
        this.executionState = executionState;
        this.exception = exception;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public Optional<Exception> getException() {
        return this.exception;
    }

    public boolean isPermanent() {
        return this.executionState == ExecutionState.PERMANENT_FAILURE;
    }

    public boolean equals(Object o) {
        if (o instanceof ExecutionResult) {
            ExecutionResult that = (ExecutionResult)o;
            return Objects.equal((Object)((Object)this.executionState), (Object)((Object)that.executionState)) && Objects.equal(this.exception, that.exception);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.executionState, this.exception});
    }

    public static enum ExecutionState {
        SUCCESS,
        PERMANENT_FAILURE,
        TEMPORARY_FAILURE;

    }
}

