/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remoteDelivery;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPSendFailedException;
import com.sun.mail.smtp.SMTPSenderFailedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

public class EnhancedMessagingException {
    private final MessagingException messagingException;
    private final Optional<Integer> returnCode;
    private final Optional<Integer> nestedReturnCode;

    public EnhancedMessagingException(MessagingException messagingException) {
        this.messagingException = messagingException;
        this.returnCode = this.computeReturnCode();
        this.nestedReturnCode = this.computeNestedReturnCode();
    }

    public boolean hasReturnCode() {
        return this.returnCode.isPresent();
    }

    public boolean hasNestedReturnCode() {
        return this.nestedReturnCode.isPresent();
    }

    public boolean isServerError() {
        return this.isServerError(this.returnCode) || this.isServerError(this.nestedReturnCode);
    }

    private boolean isServerError(Optional<Integer> returnCode) {
        return returnCode.isPresent() && (Integer)returnCode.get() >= 500 && (Integer)returnCode.get() <= 599 || this.messageIndicatesServerException();
    }

    private boolean messageIndicatesServerException() {
        return (Boolean)Optional.fromNullable((Object)this.messagingException.getMessage()).transform(this.startWith5()).or((Object)false);
    }

    private Function<String, Boolean> startWith5() {
        return new Function<String, Boolean>(){

            public Boolean apply(String input) {
                return input.startsWith("5");
            }
        };
    }

    private Optional<Integer> computeReturnCode() {
        if (this.messagingException instanceof SMTPAddressFailedException) {
            SMTPAddressFailedException addressFailedException = (SMTPAddressFailedException)this.messagingException;
            return Optional.of((Object)addressFailedException.getReturnCode());
        }
        if (this.messagingException instanceof SMTPSendFailedException) {
            SMTPSendFailedException sendFailedException = (SMTPSendFailedException)this.messagingException;
            return Optional.of((Object)sendFailedException.getReturnCode());
        }
        if (this.messagingException instanceof SMTPSenderFailedException) {
            SMTPSenderFailedException senderFailedException = (SMTPSenderFailedException)this.messagingException;
            return Optional.of((Object)senderFailedException.getReturnCode());
        }
        if (((Object)((Object)this.messagingException)).getClass().getName().endsWith(".SMTPSendFailedException") || ((Object)((Object)this.messagingException)).getClass().getName().endsWith(".SMTPAddressSucceededException")) {
            try {
                return Optional.of((Object)((Integer)this.invokeGetter((Object)this.messagingException, "getReturnCode")));
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return Optional.absent();
    }

    public Optional<String> computeCommand() {
        if (this.hasReturnCode()) {
            try {
                return Optional.of((Object)((String)this.invokeGetter((Object)this.messagingException, "getCommand")));
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return Optional.absent();
    }

    public Optional<InternetAddress> computeAddress() {
        if (this.hasReturnCode()) {
            try {
                return Optional.of((Object)((InternetAddress)this.invokeGetter((Object)this.messagingException, "getAddress")));
            }
            catch (ClassCastException classCastException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return Optional.absent();
    }

    public String computeAction() {
        return ((Object)((Object)this.messagingException)).getClass().getName().endsWith(".SMTPAddressFailedException") ? "FAILED" : "SUCCEEDED";
    }

    public Optional<Integer> getReturnCode() {
        return this.returnCode;
    }

    private Optional<Integer> computeNestedReturnCode() {
        EnhancedMessagingException currentMessagingException = this;
        while (true) {
            Optional<Integer> returnCode;
            if ((returnCode = currentMessagingException.computeReturnCode()).isPresent()) {
                return returnCode;
            }
            if (!currentMessagingException.hasNestedMessagingException()) break;
            currentMessagingException = currentMessagingException.getNestedMessagingException();
        }
        return Optional.absent();
    }

    private boolean hasNestedMessagingException() {
        return this.messagingException.getNextException() != null && this.messagingException.getNextException() instanceof MessagingException;
    }

    private EnhancedMessagingException getNestedMessagingException() {
        Preconditions.checkState((boolean)this.hasNestedMessagingException());
        return new EnhancedMessagingException((MessagingException)((Object)this.messagingException.getNextException()));
    }

    private Object invokeGetter(Object target, String getter) {
        try {
            Method getAddress = target.getClass().getMethod(getter, new Class[0]);
            return getAddress.invoke(target, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new IllegalStateException("Exception invoking " + getter + " on a " + target.getClass() + " object");
    }
}

