/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remoteDelivery;

import java.util.Iterator;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.dnsservice.api.TemporaryResolutionException;
import org.apache.james.dnsservice.library.MXHostAddressIterator;
import org.apache.james.transport.mailets.remoteDelivery.RemoteDeliveryConfiguration;
import org.apache.mailet.HostAddress;
import org.slf4j.Logger;

public class DnsHelper {
    public static final boolean USE_SEVERAL_IP = false;
    private final DNSService dnsServer;
    private final RemoteDeliveryConfiguration configuration;
    private final Logger logger;

    public DnsHelper(DNSService dnsServer, RemoteDeliveryConfiguration configuration, Logger logger) {
        this.dnsServer = dnsServer;
        this.configuration = configuration;
        this.logger = logger;
    }

    public Iterator<HostAddress> retrieveHostAddressIterator(String host) throws TemporaryResolutionException {
        if (this.configuration.getGatewayServer().isEmpty()) {
            return new MXHostAddressIterator(this.dnsServer.findMXRecords(host).iterator(), this.dnsServer, false, this.logger);
        }
        return new MXHostAddressIterator(this.configuration.getGatewayServer().iterator(), this.dnsServer, false, this.logger);
    }
}

