/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remoteDelivery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.transport.mailets.remoteDelivery.Bouncer;
import org.apache.james.transport.mailets.remoteDelivery.Delay;
import org.apache.james.transport.mailets.remoteDelivery.DeliveryRetriesHelper;
import org.apache.james.transport.mailets.remoteDelivery.ExecutionResult;
import org.apache.james.transport.mailets.remoteDelivery.MailDelivrer;
import org.apache.james.transport.mailets.remoteDelivery.MailDelivrerToHost;
import org.apache.james.transport.mailets.remoteDelivery.RemoteDeliveryConfiguration;
import org.apache.mailet.Mail;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;

public class DeliveryRunnable
implements Runnable {
    public static final Supplier<Date> CURRENT_DATE_SUPPLIER = new Supplier<Date>(){

        public Date get() {
            return new Date();
        }
    };
    public static final AtomicBoolean DEFAULT_NOT_STARTED = new AtomicBoolean(false);
    private static final String OUTGOING_MAILS = "outgoingMails";
    public static final String REMOTE_DELIVERY_TRIAL = "RemoteDeliveryTrial";
    private final MailQueue queue;
    private final RemoteDeliveryConfiguration configuration;
    private final Metric outgoingMailsMetric;
    private final MetricFactory metricFactory;
    private final Logger logger;
    private final Bouncer bouncer;
    private final MailDelivrer mailDelivrer;
    private final AtomicBoolean isDestroyed;
    private final Supplier<Date> dateSupplier;

    public DeliveryRunnable(MailQueue queue, RemoteDeliveryConfiguration configuration, DNSService dnsServer, MetricFactory metricFactory, Logger logger, MailetContext mailetContext, Bouncer bouncer, AtomicBoolean isDestroyed) {
        this(queue, configuration, metricFactory, logger, bouncer, new MailDelivrer(configuration, new MailDelivrerToHost(configuration, mailetContext, logger), dnsServer, bouncer, logger), isDestroyed, CURRENT_DATE_SUPPLIER);
    }

    @VisibleForTesting
    DeliveryRunnable(MailQueue queue, RemoteDeliveryConfiguration configuration, MetricFactory metricFactory, Logger logger, Bouncer bouncer, MailDelivrer mailDelivrer, AtomicBoolean isDestroyeds, Supplier<Date> dateSupplier) {
        this.queue = queue;
        this.configuration = configuration;
        this.outgoingMailsMetric = metricFactory.generate(OUTGOING_MAILS);
        this.logger = logger;
        this.bouncer = bouncer;
        this.mailDelivrer = mailDelivrer;
        this.isDestroyed = isDestroyeds;
        this.dateSupplier = dateSupplier;
        this.metricFactory = metricFactory;
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted() && !this.isDestroyed.get()) {
                this.runStep();
            }
        }
        finally {
            Thread.interrupted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runStep() {
        TimeMetric timeMetric = null;
        try {
            MailQueue.MailQueueItem queueItem = this.queue.deQueue();
            timeMetric = this.metricFactory.timer(REMOTE_DELIVERY_TRIAL);
            Mail mail = queueItem.getMail();
            try {
                if (this.configuration.isDebug()) {
                    this.logger.debug("{} will process mail {}", (Object)Thread.currentThread().getName(), (Object)mail.getName());
                }
                this.attemptDelivery(mail);
                LifecycleUtil.dispose((Object)mail);
                mail = null;
                queueItem.done(true);
            }
            catch (Exception e) {
                this.logger.error("Exception caught in RemoteDelivery.run()", (Throwable)e);
                LifecycleUtil.dispose((Object)mail);
                queueItem.done(false);
            }
        }
        catch (Throwable e) {
            if (!this.isDestroyed.get()) {
                this.logger.error("Exception caught in RemoteDelivery.run()", e);
            }
        }
        finally {
            if (timeMetric != null) {
                timeMetric.stopAndPublish();
            }
        }
    }

    @VisibleForTesting
    void attemptDelivery(Mail mail) throws MailQueue.MailQueueException {
        ExecutionResult executionResult = this.mailDelivrer.deliver(mail);
        switch (executionResult.getExecutionState()) {
            case SUCCESS: {
                this.outgoingMailsMetric.increment();
                break;
            }
            case TEMPORARY_FAILURE: {
                this.handleTemporaryFailure(mail, executionResult);
                break;
            }
            case PERMANENT_FAILURE: {
                this.bouncer.bounce(mail, (Exception)executionResult.getException().orNull());
            }
        }
    }

    private void handleTemporaryFailure(Mail mail, ExecutionResult executionResult) throws MailQueue.MailQueueException {
        int retries;
        if (!mail.getState().equals("error")) {
            mail.setState("error");
            DeliveryRetriesHelper.initRetries(mail);
            mail.setLastUpdated((Date)this.dateSupplier.get());
        }
        if ((retries = DeliveryRetriesHelper.retrieveRetries(mail)) < this.configuration.getMaxRetries()) {
            this.reAttemptDelivery(mail, retries);
        } else {
            this.logger.debug("Bouncing message {} after {} retries", (Object)mail.getName(), (Object)retries);
            this.bouncer.bounce(mail, new Exception("Too many retries failure. Bouncing after " + retries + " retries.", (Throwable)executionResult.getException().orNull()));
        }
    }

    private void reAttemptDelivery(Mail mail, int retries) throws MailQueue.MailQueueException {
        this.logger.debug("Storing message {} into outgoing after {} retries", (Object)mail.getName(), (Object)retries);
        DeliveryRetriesHelper.incrementRetries(mail);
        mail.setLastUpdated((Date)this.dateSupplier.get());
        long delay = this.getNextDelay(DeliveryRetriesHelper.retrieveRetries(mail));
        if (this.configuration.isUsePriority()) {
            mail.setAttribute("MAIL_PRIORITY", (Serializable)Integer.valueOf(0));
        }
        this.queue.enQueue(mail, delay, TimeUnit.MILLISECONDS);
    }

    private long getNextDelay(int retry_count) {
        if (retry_count > this.configuration.getDelayTimes().size()) {
            return Delay.DEFAULT_DELAY_TIME;
        }
        return this.configuration.getDelayTimes().get(retry_count - 1);
    }
}

