/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remoteDelivery;

import java.io.Serializable;
import org.apache.mailet.Mail;

public class DeliveryRetriesHelper {
    public static final String DELIVERY_RETRY_COUNT = "delivery_retry_count";

    public static int retrieveRetries(Mail mail) {
        try {
            Serializable value = mail.getAttribute(DELIVERY_RETRY_COUNT);
            if (value != null) {
                return (Integer)value;
            }
            return 0;
        }
        catch (ClassCastException e) {
            return 0;
        }
    }

    public static void initRetries(Mail mail) {
        mail.setAttribute(DELIVERY_RETRY_COUNT, (Serializable)Integer.valueOf(0));
    }

    public static void incrementRetries(Mail mail) {
        mail.setAttribute(DELIVERY_RETRY_COUNT, (Serializable)Integer.valueOf(DeliveryRetriesHelper.retrieveRetries(mail) + 1));
    }
}

