/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remoteDelivery;

import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.apache.mailet.MailetContext;

public class Converter7Bit {
    private final MailetContext mailetContext;

    public Converter7Bit(MailetContext mailetContext) {
        this.mailetContext = mailetContext;
    }

    public MimePart convertTo7Bit(MimePart part) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            MimeMultipart parts = (MimeMultipart)part.getContent();
            int count = parts.getCount();
            for (int i = 0; i < count; ++i) {
                this.convertTo7Bit((MimePart)parts.getBodyPart(i));
            }
        } else if ("8bit".equals(part.getEncoding())) {
            String contentTransferEncoding = part.isMimeType("text/*") ? "quoted-printable" : "base64";
            part.setContent(part.getContent(), part.getContentType());
            part.setHeader("Content-Transfer-Encoding", contentTransferEncoding);
            part.addHeader("X-MIME-Autoconverted", "from 8bit to " + contentTransferEncoding + " by " + this.mailetContext.getServerInfo());
        }
        return part;
    }
}

