/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remoteDelivery;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import org.apache.james.transport.mailets.remoteDelivery.RemoteDeliveryConfiguration;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetContext;
import org.slf4j.Logger;

public class Bouncer {
    public static final String DELIVERY_ERROR = "delivery-error";
    private final RemoteDeliveryConfiguration configuration;
    private final MailetContext mailetContext;
    private final Logger logger;

    public Bouncer(RemoteDeliveryConfiguration configuration, MailetContext mailetContext, Logger logger) {
        this.configuration = configuration;
        this.mailetContext = mailetContext;
        this.logger = logger;
    }

    public void bounce(Mail mail, Exception ex) {
        if (mail.getSender() == null) {
            this.logger.debug("Null Sender: no bounce will be generated for {}", (Object)mail.getName());
        } else if (this.configuration.getBounceProcessor() != null) {
            mail.setAttribute(DELIVERY_ERROR, (Serializable)((Object)this.getErrorMsg(ex)));
            mail.setState(this.configuration.getBounceProcessor());
            try {
                this.mailetContext.sendMail(mail);
            }
            catch (MessagingException e) {
                this.logger.warn("Exception re-inserting failed mail: ", (Throwable)e);
            }
        } else {
            this.bounceWithMailetContext(mail, ex);
        }
    }

    private void bounceWithMailetContext(Mail mail, Exception ex) {
        this.logger.debug("Sending failure message " + mail.getName());
        try {
            this.mailetContext.bounce(mail, this.explanationText(mail, ex));
        }
        catch (MessagingException me) {
            this.logger.warn("Encountered unexpected messaging exception while bouncing message: {}", (Object)me.getMessage());
        }
        catch (Exception e) {
            this.logger.warn("Encountered unexpected exception while bouncing message: {}", (Object)e.getMessage());
        }
    }

    public String explanationText(Mail mail, Exception ex) {
        StringWriter sout = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)sout, true);
        out.println("Hi. This is the James mail server at " + this.resolveMachineName() + ".");
        out.println("I'm afraid I wasn't able to deliver your message to the following addresses.");
        out.println("This is a permanent error; I've given up. Sorry it didn't work out. Below");
        out.println("I include the list of recipients and the reason why I was unable to deliver");
        out.println("your message.");
        out.println();
        for (MailAddress mailAddress : mail.getRecipients()) {
            out.println(mailAddress);
        }
        if (ex instanceof MessagingException) {
            if (((MessagingException)((Object)ex)).getNextException() == null) {
                out.println(this.sanitizeExceptionMessage(ex));
            } else {
                Exception ex1 = ((MessagingException)((Object)ex)).getNextException();
                if (ex1 instanceof SendFailedException) {
                    out.println("Remote mail server told me: " + this.sanitizeExceptionMessage(ex1));
                } else if (ex1 instanceof UnknownHostException) {
                    out.println("Unknown host: " + this.sanitizeExceptionMessage(ex1));
                    out.println("This could be a DNS server error, a typo, or a problem with the recipient's mail server.");
                } else if (ex1 instanceof ConnectException) {
                    out.println(this.sanitizeExceptionMessage(ex1));
                } else if (ex1 instanceof SocketException) {
                    out.println("Socket exception: " + this.sanitizeExceptionMessage(ex1));
                } else {
                    out.println(this.sanitizeExceptionMessage(ex1));
                }
            }
        }
        out.println();
        return sout.toString();
    }

    private String sanitizeExceptionMessage(Exception e) {
        if (e.getMessage() == null) {
            return "null";
        }
        return e.getMessage().trim();
    }

    private String resolveMachineName() {
        try {
            return this.configuration.getHeloNameProvider().getHeloName();
        }
        catch (Exception e) {
            return "[address unknown]";
        }
    }

    public String getErrorMsg(Exception ex) {
        if (ex instanceof MessagingException) {
            return this.getNestedExceptionMessage((MessagingException)((Object)ex));
        }
        return this.sanitizeExceptionMessage(ex);
    }

    public String getNestedExceptionMessage(MessagingException me) {
        if (me.getNextException() == null) {
            return this.sanitizeExceptionMessage((Exception)((Object)me));
        }
        Exception ex1 = me.getNextException();
        return this.sanitizeExceptionMessage(ex1);
    }
}

