/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.remoteDelivery;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import org.apache.mailet.MailAddress;
import org.slf4j.Logger;

public class AddressesArrayToMailAddressListConverter {
    public static List<MailAddress> getAddressesAsMailAddress(Address[] addresses, final Logger logger) {
        if (addresses == null) {
            return ImmutableList.of();
        }
        return FluentIterable.from(Arrays.asList(addresses)).transform((Function)new Function<Address, Optional<MailAddress>>(){

            public Optional<MailAddress> apply(Address input) {
                try {
                    return Optional.of((Object)new MailAddress(input.toString()));
                }
                catch (AddressException e) {
                    logger.debug("Can't parse unsent address: {}", (Object)e.getMessage());
                    return Optional.absent();
                }
            }
        }).filter((Predicate)new Predicate<Optional<MailAddress>>(){

            public boolean apply(Optional<MailAddress> input) {
                return input.isPresent();
            }
        }).transform((Function)new Function<Optional<MailAddress>, MailAddress>(){

            public MailAddress apply(Optional<MailAddress> input) {
                return (MailAddress)input.get();
            }
        }).toList();
    }
}

