/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import com.google.common.base.Throwables;
import org.apache.james.transport.mailets.redirect.SpecialAddressKind;
import org.apache.mailet.MailAddress;

public class SpecialAddress {
    public static final MailAddress SENDER = AddressMarker.SENDER;
    public static final MailAddress REVERSE_PATH = AddressMarker.REVERSE_PATH;
    public static final MailAddress FROM = AddressMarker.FROM;
    public static final MailAddress REPLY_TO = AddressMarker.REPLY_TO;
    public static final MailAddress TO = AddressMarker.TO;
    public static final MailAddress RECIPIENTS = AddressMarker.RECIPIENTS;
    public static final MailAddress DELETE = AddressMarker.DELETE;
    public static final MailAddress UNALTERED = AddressMarker.UNALTERED;
    public static final MailAddress NULL = AddressMarker.NULL;

    public static boolean isSpecialAddress(MailAddress mailAddress) {
        return mailAddress.getDomain().equalsIgnoreCase("address.marker");
    }

    public static class AddressMarker {
        public static final String ADDRESS_MARKER = "address.marker";
        public static final MailAddress SENDER = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.SENDER, "address.marker");
        public static final MailAddress REVERSE_PATH = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.REVERSE_PATH, "address.marker");
        public static final MailAddress FROM = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.FROM, "address.marker");
        public static final MailAddress REPLY_TO = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.REPLY_TO, "address.marker");
        public static final MailAddress TO = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.TO, "address.marker");
        public static final MailAddress RECIPIENTS = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.RECIPIENTS, "address.marker");
        public static final MailAddress DELETE = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.DELETE, "address.marker");
        public static final MailAddress UNALTERED = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.UNALTERED, "address.marker");
        public static final MailAddress NULL = AddressMarker.mailAddressUncheckedException(SpecialAddressKind.NULL, "address.marker");

        private static MailAddress mailAddressUncheckedException(SpecialAddressKind kind, String domain) {
            try {
                return new MailAddress(kind.getValue(), domain);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

