/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import org.apache.james.transport.mailets.redirect.InitParameters;
import org.apache.james.transport.mailets.redirect.InitParametersSerializer;
import org.apache.james.transport.mailets.redirect.LoadedOnceInitParameters;
import org.apache.james.transport.mailets.redirect.TypeCode;
import org.apache.mailet.base.GenericMailet;

public class RedirectMailetInitParameters
implements InitParameters {
    private final GenericMailet mailet;
    private final Optional<TypeCode> defaultAttachmentType;
    private final Optional<TypeCode> defaultInLineType;

    public static InitParameters from(GenericMailet mailet) {
        RedirectMailetInitParameters initParameters = new RedirectMailetInitParameters(mailet, (Optional<TypeCode>)Optional.absent(), (Optional<TypeCode>)Optional.absent());
        if (initParameters.isStatic()) {
            return LoadedOnceInitParameters.from(initParameters);
        }
        return initParameters;
    }

    public static InitParameters from(GenericMailet mailet, Optional<TypeCode> defaultAttachmentType, Optional<TypeCode> defaultInLineType) {
        RedirectMailetInitParameters initParameters = new RedirectMailetInitParameters(mailet, defaultAttachmentType, defaultAttachmentType);
        if (initParameters.isStatic()) {
            return LoadedOnceInitParameters.from(initParameters);
        }
        return initParameters;
    }

    private RedirectMailetInitParameters(GenericMailet mailet, Optional<TypeCode> defaultAttachmentType, Optional<TypeCode> defaultInLineType) {
        this.mailet = mailet;
        this.defaultAttachmentType = defaultAttachmentType;
        this.defaultInLineType = defaultInLineType;
    }

    @Override
    public boolean getPassThrough() {
        return this.mailet.getInitParameter("passThrough", false);
    }

    @Override
    public boolean getFakeDomainCheck() {
        return this.mailet.getInitParameter("fakeDomainCheck", false);
    }

    @Override
    public TypeCode getInLineType() {
        return (TypeCode)((Object)this.defaultInLineType.or((Object)TypeCode.from(this.mailet.getInitParameter("inline", "unaltered"))));
    }

    @Override
    public TypeCode getAttachmentType() {
        return (TypeCode)((Object)this.defaultAttachmentType.or((Object)TypeCode.from(this.mailet.getInitParameter("attachment", "none"))));
    }

    @Override
    public String getMessage() {
        return this.mailet.getInitParameter("message", "");
    }

    @Override
    public String getSubject() {
        return this.mailet.getInitParameter("subject");
    }

    @Override
    public String getSubjectPrefix() {
        return this.mailet.getInitParameter("prefix");
    }

    @Override
    public boolean isAttachError() {
        return this.mailet.getInitParameter("attachError", false);
    }

    @Override
    public boolean isReply() {
        return this.mailet.getInitParameter("isReply", false);
    }

    @Override
    public Optional<String> getRecipients() {
        return this.mailet.getInitParameterAsOptional("recipients");
    }

    @Override
    public Optional<String> getTo() {
        return this.mailet.getInitParameterAsOptional("to");
    }

    @Override
    public Optional<String> getReversePath() {
        return this.mailet.getInitParameterAsOptional("reversePath");
    }

    @Override
    public Optional<String> getSender() {
        return this.mailet.getInitParameterAsOptional("sender");
    }

    @Override
    public Optional<String> getReplyTo() {
        String recipients = this.mailet.getInitParameter("replyTo", this.mailet.getInitParameter("replyto"));
        if (Strings.isNullOrEmpty((String)recipients)) {
            return Optional.absent();
        }
        return Optional.of((Object)recipients);
    }

    @Override
    public boolean isDebug() {
        return this.mailet.getInitParameter("debug", false);
    }

    @Override
    public boolean isStatic() {
        return this.mailet.getInitParameter("static", false);
    }

    @Override
    public String asString() {
        return InitParametersSerializer.serialize(this);
    }
}

