/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailImpl;
import org.apache.james.transport.mailets.redirect.MailMessageAlteringUtils;
import org.apache.james.transport.mailets.redirect.MailModifier;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.TypeCode;
import org.apache.mailet.Mail;
import org.apache.mailet.base.StringUtils;

public class ProcessRedirectNotify {
    private final RedirectNotify mailet;
    private final boolean isDebug;

    public static ProcessRedirectNotify from(RedirectNotify mailet) {
        return new ProcessRedirectNotify(mailet);
    }

    private ProcessRedirectNotify(RedirectNotify mailet) {
        this.mailet = mailet;
        this.isDebug = mailet.getInitParameters().isDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Mail originalMail) throws MessagingException {
        block9: {
            MailImpl newMail = new MailImpl(originalMail);
            try {
                boolean keepMessageId;
                MailModifier mailModifier = MailModifier.builder().mailet(this.mailet).mail(newMail).dns(this.mailet.getDNSService()).build();
                mailModifier.setRemoteAddr();
                mailModifier.setRemoteHost();
                if (this.mailet.getInitParameters().isDebug()) {
                    this.mailet.log("New mail - sender: " + newMail.getSender() + ", recipients: " + StringUtils.arrayToString((Object[])newMail.getRecipients().toArray()) + ", name: " + newMail.getName() + ", remoteHost: " + newMail.getRemoteHost() + ", remoteAddr: " + newMail.getRemoteAddr() + ", state: " + newMail.getState() + ", lastUpdated: " + newMail.getLastUpdated() + ", errorMessage: " + newMail.getErrorMessage());
                }
                if (!(keepMessageId = this.keepMessageId())) {
                    this.createAlterMessage(originalMail, newMail);
                } else {
                    this.createUnalteredMessage(originalMail, newMail);
                }
                mailModifier.setRecipients(this.mailet.getRecipients(originalMail));
                mailModifier.setTo(this.mailet.getTo(originalMail));
                mailModifier.setSubjectPrefix(originalMail);
                mailModifier.setReplyTo(this.mailet.getReplyTo(originalMail), originalMail);
                mailModifier.setReversePath(this.mailet.getReversePath(originalMail), originalMail);
                mailModifier.setIsReply(this.mailet.getInitParameters().isReply(), originalMail);
                mailModifier.setSender(this.mailet.getSender(originalMail), originalMail);
                mailModifier.initializeDateIfNotPresent();
                if (keepMessageId) {
                    mailModifier.setMessageId(originalMail);
                }
                this.finalize(newMail);
                if (this.senderDomainIsValid((Mail)newMail)) {
                    this.mailet.getMailetContext().sendMail((Mail)newMail);
                    break block9;
                }
                throw new MessagingException(this.mailet.getMailetName() + " mailet cannot forward " + originalMail.getName() + ". Invalid sender domain for " + newMail.getSender() + ". Consider using the Resend mailet using a different sender.");
            }
            finally {
                newMail.dispose();
            }
        }
        if (!this.mailet.getInitParameters().getPassThrough()) {
            originalMail.setState("ghost");
        }
    }

    private void finalize(MailImpl mail) throws MessagingException {
        mail.getMessage().saveChanges();
        mail.removeAllAttributes();
    }

    private boolean keepMessageId() {
        return this.mailet.getInitParameters().getInLineType().equals((Object)TypeCode.UNALTERED);
    }

    private void createAlterMessage(Mail originalMail, MailImpl newMail) throws MessagingException {
        if (this.isDebug) {
            this.mailet.log("Alter message");
        }
        newMail.setMessage(new MimeMessage(Session.getDefaultInstance((Properties)System.getProperties(), null)));
        MailMessageAlteringUtils.from(this.mailet).originalMail(originalMail).newMail((Mail)newMail).alterNewMessage();
    }

    private void createUnalteredMessage(Mail originalMail, MailImpl newMail) throws MessagingException {
        if (this.mailet.getInitParameters().getPassThrough()) {
            newMail.setMessage((MimeMessage)new CopiedMimeMessage(originalMail.getMessage()));
        }
        if (this.isDebug) {
            this.mailet.log("Message resent unaltered.");
        }
    }

    private boolean senderDomainIsValid(Mail mail) throws MessagingException {
        return !this.mailet.getInitParameters().getFakeDomainCheck() || mail.getSender() == null || !this.mailet.getMailetContext().getMailServers(mail.getSender().getDomain()).isEmpty();
    }

    private static class CopiedMimeMessage
    extends MimeMessage {
        public CopiedMimeMessage(MimeMessage originalMessage) throws MessagingException {
            super(originalMessage);
        }

        protected void updateHeaders() throws MessagingException {
            if (this.getMessageID() == null) {
                super.updateHeaders();
            } else {
                this.modified = false;
            }
        }
    }
}

