/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class NotifyMailetsMessage {
    private static final char LINE_BREAK = '\n';

    public String generateMessage(String parameterMessage, Mail originalMail) throws MessagingException {
        MimeMessage message = originalMail.getMessage();
        StringBuilder builder = new StringBuilder();
        builder.append(parameterMessage).append('\n');
        if (originalMail.getErrorMessage() != null) {
            builder.append('\n').append("Error message below:").append('\n').append(originalMail.getErrorMessage()).append('\n');
        }
        builder.append('\n').append("Message details:").append('\n');
        if (message.getSubject() != null) {
            builder.append("  Subject: " + message.getSubject()).append('\n');
        }
        if (message.getSentDate() != null) {
            builder.append("  Sent date: " + message.getSentDate()).append('\n');
        }
        builder.append("  MAIL FROM: " + originalMail.getSender()).append('\n');
        boolean firstRecipient = true;
        for (MailAddress recipient : originalMail.getRecipients()) {
            if (firstRecipient) {
                builder.append("  RCPT TO: " + recipient).append('\n');
                firstRecipient = false;
                continue;
            }
            builder.append("           " + recipient).append('\n');
        }
        this.appendAddresses(builder, "From", message.getHeader("From"));
        this.appendAddresses(builder, "To", message.getHeader("To"));
        this.appendAddresses(builder, "CC", message.getHeader("Cc"));
        builder.append("  Size (in bytes): " + message.getSize()).append('\n');
        if (message.getLineCount() >= 0) {
            builder.append("  Number of lines: " + message.getLineCount()).append('\n');
        }
        return builder.toString();
    }

    private void appendAddresses(StringBuilder builder, String title, String[] addresses) {
        if (addresses != null) {
            builder.append("  " + title + ": ").append('\n');
            for (String address : this.flatten(addresses)) {
                builder.append(address + " ").append('\n');
            }
            builder.append('\n');
        }
    }

    private List<String> flatten(String[] addresses) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String address : addresses) {
            builder.addAll(Splitter.on((char)',').trimResults().split((CharSequence)address));
        }
        return builder.build();
    }
}

