/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.james.core.MailImpl;
import org.apache.james.dnsservice.api.DNSService;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.SpecialAddress;
import org.apache.james.transport.util.MailAddressUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.base.DateFormats;
import org.apache.mailet.base.StringUtils;

public class MailModifier {
    private static final String LOCAHOST = "127.0.0.1";
    private final RedirectNotify mailet;
    private final MailImpl mail;
    private final DNSService dns;

    public static Builder builder() {
        return new Builder();
    }

    private MailModifier(RedirectNotify mailet, MailImpl mail, DNSService dns) {
        this.mailet = mailet;
        this.mail = mail;
        this.dns = dns;
    }

    public void setRemoteAddr() {
        try {
            this.mail.setRemoteAddr(this.dns.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            this.mail.setRemoteAddr(LOCAHOST);
        }
    }

    public void setRemoteHost() {
        try {
            this.mail.setRemoteHost(this.dns.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            this.mail.setRemoteHost("localhost");
        }
    }

    public void setRecipients(List<MailAddress> recipients) {
        if (!recipients.isEmpty()) {
            this.mail.setRecipients(recipients);
            if (this.mailet.getInitParameters().isDebug()) {
                this.mailet.log("recipients set to: " + StringUtils.arrayToString((Object[])recipients.toArray()));
            }
        }
    }

    public void setTo(List<MailAddress> mailAddresses) throws MessagingException {
        if (!mailAddresses.isEmpty()) {
            InternetAddress[] internetAddresses = MailAddressUtils.toInternetAddressArray(mailAddresses);
            this.mail.getMessage().setRecipients(Message.RecipientType.TO, (Address[])internetAddresses);
            if (this.mailet.getInitParameters().isDebug()) {
                this.mailet.log("apparentlyTo set to: " + internetAddresses);
            }
        }
    }

    public void setSubjectPrefix(Mail originalMail) throws MessagingException {
        this.mailet.getMimeMessageModifier((Mail)this.mail, originalMail).replaceSubject(this.mailet.getSubjectPrefix((Mail)this.mail, this.mailet.getInitParameters().getSubjectPrefix(), originalMail));
    }

    public void setReplyTo(Optional<MailAddress> optionalReplyTo, Mail originalMail) throws MessagingException {
        if (optionalReplyTo.isPresent()) {
            MailAddress replyTo = (MailAddress)optionalReplyTo.get();
            if (replyTo.equals((Object)SpecialAddress.NULL)) {
                this.mail.getMessage().setReplyTo(null);
                if (this.mailet.getInitParameters().isDebug()) {
                    this.mailet.log("replyTo set to: null");
                }
            } else {
                this.mail.getMessage().setReplyTo((Address[])new InternetAddress[]{replyTo.toInternetAddress()});
                if (this.mailet.getInitParameters().isDebug()) {
                    this.mailet.log("replyTo set to: " + replyTo);
                }
            }
        }
    }

    public void setReversePath(Optional<MailAddress> maybeReversePath, Mail originalMail) {
        if (maybeReversePath.isPresent()) {
            MailAddress reversePath = (MailAddress)maybeReversePath.get();
            if (reversePath.equals((Object)SpecialAddress.NULL)) {
                this.mail.setSender(null);
                if (this.mailet.getInitParameters().isDebug()) {
                    this.mailet.log("reversePath set to: null");
                }
            } else {
                this.mail.setSender(reversePath);
                if (this.mailet.getInitParameters().isDebug()) {
                    this.mailet.log("reversePath set to: " + reversePath);
                }
            }
        }
    }

    public void setIsReply(boolean isReply, Mail originalMail) throws MessagingException {
        String messageId;
        if (isReply && (messageId = originalMail.getMessage().getMessageID()) != null) {
            this.mail.getMessage().setHeader("In-Reply-To", messageId);
            if (this.mailet.getInitParameters().isDebug()) {
                this.mailet.log("IN_REPLY_TO set to: " + messageId);
            }
        }
    }

    public void setSender(Optional<MailAddress> sender, Mail originalMail) throws MessagingException {
        if (sender.isPresent()) {
            this.mail.getMessage().setFrom((Address)((MailAddress)sender.get()).toInternetAddress());
            if (this.mailet.getInitParameters().isDebug()) {
                this.mailet.log("sender set to: " + sender);
            }
        }
    }

    public void initializeDateIfNotPresent() throws MessagingException {
        if (this.mail.getMessage().getHeader("Date") == null) {
            this.mail.getMessage().setHeader("Date", DateFormats.RFC822_DATE_FORMAT.format(new Date()));
        }
    }

    public void setMessageId(Mail originalMail) throws MessagingException {
        String messageId = originalMail.getMessage().getMessageID();
        if (messageId != null) {
            this.mail.getMessage().setHeader("Message-ID", messageId);
            if (this.mailet.getInitParameters().isDebug()) {
                this.mailet.log("MESSAGE_ID restored to: " + messageId);
            }
        }
    }

    public MailImpl getMail() {
        return this.mail;
    }

    public static class Builder {
        private RedirectNotify mailet;
        private MailImpl mail;
        private DNSService dns;

        private Builder() {
        }

        public Builder mailet(RedirectNotify mailet) {
            this.mailet = mailet;
            return this;
        }

        public Builder mail(MailImpl mail) {
            this.mail = mail;
            return this;
        }

        public Builder dns(DNSService dns) {
            this.dns = dns;
            return this;
        }

        public MailModifier build() {
            Preconditions.checkNotNull((Object)this.mailet, (Object)"'mailet' is mandatory");
            Preconditions.checkNotNull((Object)this.mail, (Object)"'mail' is mandatory");
            Preconditions.checkNotNull((Object)this.dns, (Object)"'dns' is mandatory");
            return new MailModifier(this.mailet, this.mail, this.dns);
        }
    }
}

