/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.redirect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.james.core.MimeMessageUtil;
import org.apache.james.transport.mailets.redirect.RedirectNotify;
import org.apache.james.transport.mailets.redirect.TypeCode;
import org.apache.james.transport.mailets.utils.MimeMessageUtils;
import org.apache.mailet.Mail;

public class MailMessageAlteringUtils {
    private static final char LINE_BREAK = '\n';
    private final RedirectNotify mailet;
    private final Mail originalMail;
    private final Mail newMail;

    public static Builder from(RedirectNotify mailet) {
        return new Builder(mailet);
    }

    private MailMessageAlteringUtils(RedirectNotify mailet, Mail originalMail, Mail newMail) {
        this.mailet = mailet;
        this.originalMail = originalMail;
        this.newMail = newMail;
    }

    private void alterNewMessage() throws MessagingException {
        MimeMessage originalMessage = this.originalMail.getMessage();
        MimeMessage newMessage = this.newMail.getMessage();
        this.copyRelevantHeaders(originalMessage, newMessage);
        String head = new MimeMessageUtils(originalMessage).getMessageHeaders();
        try {
            MimeMultipart multipart = new MimeMultipart("mixed");
            MimeMultipart mpContent = new MimeMultipart("alternative");
            mpContent.addBodyPart(this.getBodyPart(this.originalMail, originalMessage, head));
            MimeBodyPart contentPartRoot = new MimeBodyPart();
            contentPartRoot.setContent((Multipart)mpContent);
            multipart.addBodyPart((BodyPart)contentPartRoot);
            if (this.mailet.getInitParameters().isDebug()) {
                this.mailet.log("attachmentType:" + (Object)((Object)this.mailet.getInitParameters().getAttachmentType()));
            }
            if (!this.mailet.getInitParameters().getAttachmentType().equals((Object)TypeCode.NONE)) {
                multipart.addBodyPart((BodyPart)this.getAttachmentPart(originalMessage, head));
            }
            if (this.mailet.getInitParameters().isAttachError() && this.originalMail.getErrorMessage() != null) {
                multipart.addBodyPart((BodyPart)this.getErrorPart(this.originalMail));
            }
            this.newMail.getMessage().setContent((Multipart)multipart);
            this.newMail.getMessage().setHeader("Content-Type", multipart.getContentType());
        }
        catch (Exception ioe) {
            throw new MessagingException("Unable to create multipart body", ioe);
        }
    }

    private BodyPart getBodyPart(Mail originalMail, MimeMessage originalMessage, String head) throws MessagingException, Exception {
        MimeBodyPart part = new MimeBodyPart();
        part.setText(this.getText(originalMail, originalMessage, head));
        part.setDisposition("inline");
        return part;
    }

    private MimeBodyPart getAttachmentPart(MimeMessage originalMessage, String head) throws MessagingException, Exception {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        switch (this.mailet.getInitParameters().getAttachmentType()) {
            case HEADS: {
                attachmentPart.setText(head);
                break;
            }
            case BODY: {
                try {
                    attachmentPart.setText(this.getMessageBody(originalMessage));
                }
                catch (Exception e) {
                    attachmentPart.setText("body unavailable");
                }
                break;
            }
            case ALL: {
                attachmentPart.setText(head + "\r\nMessage:\r\n" + this.getMessageBody(originalMessage));
                break;
            }
            case MESSAGE: {
                attachmentPart.setContent((Object)originalMessage, "message/rfc822");
                break;
            }
            case NONE: {
                break;
            }
        }
        attachmentPart.setFileName(this.getFileName(originalMessage.getSubject()));
        attachmentPart.setDisposition("attachment");
        return attachmentPart;
    }

    @VisibleForTesting
    String getFileName(String subject) {
        if (subject != null && !subject.trim().isEmpty()) {
            return subject.trim();
        }
        return "No Subject";
    }

    private MimeBodyPart getErrorPart(Mail originalMail) throws MessagingException {
        MimeBodyPart errorPart = new MimeBodyPart();
        errorPart.setContent((Object)originalMail.getErrorMessage(), "text/plain");
        errorPart.setHeader("Content-Type", "text/plain");
        errorPart.setFileName("Reasons");
        errorPart.setDisposition("attachment");
        return errorPart;
    }

    private String getText(Mail originalMail, MimeMessage originalMessage, String head) throws MessagingException {
        StringBuilder builder = new StringBuilder();
        String messageText = this.mailet.getMessage(originalMail);
        if (messageText != null) {
            builder.append(messageText).append('\n');
        }
        if (this.mailet.getInitParameters().isDebug()) {
            this.mailet.log("inline:" + (Object)((Object)this.mailet.getInitParameters().getInLineType()));
        }
        switch (this.mailet.getInitParameters().getInLineType()) {
            case ALL: {
                builder.append(this.headText(head));
                builder.append(this.bodyText(originalMessage));
                break;
            }
            case HEADS: {
                builder.append(this.headText(head));
                break;
            }
            case BODY: {
                builder.append(this.bodyText(originalMessage));
                break;
            }
            case NONE: {
                break;
            }
            case MESSAGE: {
                break;
            }
        }
        return builder.toString();
    }

    private String headText(String head) {
        return "Message Headers:\n" + head + '\n';
    }

    private String bodyText(MimeMessage originalMessage) {
        StringBuilder builder = new StringBuilder();
        builder.append("Message:").append('\n');
        try {
            builder.append(this.getMessageBody(originalMessage)).append('\n');
        }
        catch (Exception e) {
            builder.append("body unavailable").append('\n');
        }
        return builder.toString();
    }

    private String getMessageBody(MimeMessage message) throws Exception {
        ByteArrayOutputStream bodyOs = new ByteArrayOutputStream();
        MimeMessageUtil.writeMessageBodyTo((MimeMessage)message, (OutputStream)bodyOs);
        return bodyOs.toString();
    }

    private void copyRelevantHeaders(MimeMessage originalMessage, MimeMessage newMessage) throws MessagingException {
        Enumeration headerEnum = originalMessage.getMatchingHeaderLines(new String[]{"Date", "From", "Reply-To", "To", "Subject", "Return-Path"});
        while (headerEnum.hasMoreElements()) {
            newMessage.addHeaderLine((String)headerEnum.nextElement());
        }
    }

    public static class Builder {
        private RedirectNotify mailet;
        private Mail originalMail;
        private Mail newMail;

        private Builder(RedirectNotify mailet) {
            this.mailet = mailet;
        }

        public Builder originalMail(Mail originalMail) {
            this.originalMail = originalMail;
            return this;
        }

        public Builder newMail(Mail newMail) {
            this.newMail = newMail;
            return this;
        }

        public void alterNewMessage() throws MessagingException {
            this.build().alterNewMessage();
        }

        @VisibleForTesting
        MailMessageAlteringUtils build() {
            Preconditions.checkNotNull((Object)this.mailet, (Object)"'mailet' is mandatory");
            Preconditions.checkNotNull((Object)this.originalMail, (Object)"'originalMail' is mandatory");
            Preconditions.checkNotNull((Object)this.newMail, (Object)"'newMail' is mandatory");
            return new MailMessageAlteringUtils(this.mailet, this.originalMail, this.newMail);
        }
    }
}

