/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.managesieve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import java.util.Scanner;
import javax.inject.Inject;
import javax.mail.MessagingException;
import org.apache.james.managesieve.api.Session;
import org.apache.james.managesieve.api.SieveParser;
import org.apache.james.managesieve.api.commands.CoreCommands;
import org.apache.james.managesieve.core.CoreProcessor;
import org.apache.james.managesieve.transcode.ArgumentParser;
import org.apache.james.managesieve.transcode.ManageSieveProcessor;
import org.apache.james.managesieve.util.SettableSession;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.transport.mailets.managesieve.transcode.MessageToCoreToMessage;
import org.apache.james.user.api.UsersRepository;
import org.apache.mailet.Experimental;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetContext;
import org.apache.mailet.base.GenericMailet;

@Experimental
public class ManageSieveMailet
extends GenericMailet
implements MessageToCoreToMessage.HelpProvider {
    private SieveRepository sieveRepository = null;
    private SieveParser sieveParser = null;
    private UsersRepository usersRepository;
    private MessageToCoreToMessage transcoder = null;
    private URL helpURL = null;
    private String help = null;
    private boolean cache = true;

    public void init() throws MessagingException {
        super.init();
        if (null == this.sieveParser) {
            throw new MessagingException("Missing resource \"sieveparser\"");
        }
        if (null == this.sieveRepository) {
            throw new MessagingException("Missing resource \"sieverepository\"");
        }
        this.setHelpURL(this.getInitParameter("helpURL"));
        this.cache = this.getInitParameter("cache", true);
        this.transcoder = new MessageToCoreToMessage(new ManageSieveProcessor(new ArgumentParser((CoreCommands)new CoreProcessor(this.sieveRepository, this.usersRepository, this.sieveParser))), this);
    }

    public void service(Mail mail) throws MessagingException {
        if (mail.getSender() == null) {
            this.getMailetContext().log(MailetContext.LogLevel.ERROR, "Sender is null");
            return;
        }
        if (!this.getMailetContext().isLocalServer(mail.getSender().getDomain().toLowerCase(Locale.US))) {
            this.getMailetContext().log(MailetContext.LogLevel.ERROR, "Sender not local");
            return;
        }
        SettableSession session = new SettableSession();
        if (mail.getAttribute("org.apache.james.SMTPAuthUser") != null) {
            session.setState(Session.State.AUTHENTICATED);
        } else {
            session.setState(Session.State.UNAUTHENTICATED);
        }
        session.setUser(mail.getSender().getLocalPart() + '@' + (mail.getSender().getDomain() == null ? "localhost" : mail.getSender().getDomain()));
        this.getMailetContext().sendMail((MailAddress)mail.getRecipients().iterator().next(), (Collection)Lists.newArrayList((Object[])new MailAddress[]{mail.getSender()}), this.transcoder.execute((Session)session, mail.getMessage()));
        mail.setState("ghost");
        this.clearCaches();
    }

    @Inject
    public void setSieveRepository(SieveRepository repository) {
        this.sieveRepository = repository;
    }

    @Inject
    public void setSieveParser(SieveParser sieveParser) {
        this.sieveParser = sieveParser;
    }

    @Inject
    public void setUsersRepository(UsersRepository usersRepository) {
        this.usersRepository = usersRepository;
    }

    public String getMailetInfo() {
        return this.getClass().getName();
    }

    private void setHelpURL(String helpURL) throws MessagingException {
        try {
            this.helpURL = new URL(helpURL);
        }
        catch (MalformedURLException ex) {
            throw new MessagingException("Invalid helpURL", (Exception)ex);
        }
    }

    private void clearCaches() {
        if (!this.cache) {
            this.help = null;
        }
    }

    @Override
    @VisibleForTesting
    public String getHelp() throws MessagingException {
        if (null == this.help) {
            this.help = this.computeHelp();
        }
        return this.help;
    }

    private String computeHelp() throws MessagingException {
        InputStream stream = null;
        Scanner scanner = null;
        try {
            stream = this.helpURL.openStream();
            scanner = new Scanner(stream, "UTF-8");
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
        catch (IOException ex) {
            throw new MessagingException("Unable to access help URL: " + this.helpURL.toExternalForm(), (Exception)ex);
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
        }
    }
}

