/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve.mdn;

import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.james.transport.mailets.jsieve.mdn.Disposition;
import org.apache.mailet.base.mail.MimeMultipartReport;

public class MDNFactory {
    private MDNFactory() {
    }

    public static MimeMultipartReport create(String humanText, String reporting_UA_name, String reporting_UA_product, String original_recipient, String final_recipient, String original_message_id, Disposition disposition) throws MessagingException {
        MimeMultipartReport multiPart = new MimeMultipartReport();
        multiPart.setReportType("disposition-notification");
        MimeBodyPart humanPart = new MimeBodyPart();
        humanPart.setText(humanText);
        multiPart.addBodyPart((BodyPart)humanPart);
        StringBuilder mdnReport = new StringBuilder(128);
        mdnReport.append("Reporting-UA: ");
        mdnReport.append(reporting_UA_name == null ? "" : reporting_UA_name);
        mdnReport.append("; ");
        mdnReport.append(reporting_UA_product == null ? "" : reporting_UA_product);
        mdnReport.append("\r\n");
        if (null != original_recipient) {
            mdnReport.append("Original-Recipient: ");
            mdnReport.append("rfc822; ");
            mdnReport.append(original_recipient);
            mdnReport.append("\r\n");
        }
        mdnReport.append("Final-Recepient: ");
        mdnReport.append("rfc822; ");
        mdnReport.append(final_recipient == null ? "" : final_recipient);
        mdnReport.append("\r\n");
        mdnReport.append("Original-Message-ID: ");
        mdnReport.append(original_message_id == null ? "" : original_message_id);
        mdnReport.append("\r\n");
        mdnReport.append(disposition.toString());
        mdnReport.append("\r\n");
        MimeBodyPart mdnPart = new MimeBodyPart();
        mdnPart.setContent((Object)mdnReport.toString(), "message/disposition-notification");
        multiPart.addBodyPart((BodyPart)mdnPart);
        return multiPart;
    }
}

