/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve.delivery;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.transport.mailets.jsieve.ActionDispatcher;
import org.apache.james.transport.mailets.jsieve.ResourceLocator;
import org.apache.james.transport.mailets.jsieve.SieveMailAdapter;
import org.apache.james.transport.mailets.jsieve.delivery.SieveFailureMessageComposer;
import org.apache.james.transport.mailets.jsieve.delivery.SievePoster;
import org.apache.jsieve.ConfigurationManager;
import org.apache.jsieve.SieveConfigurationException;
import org.apache.jsieve.SieveFactory;
import org.apache.jsieve.exception.SieveException;
import org.apache.jsieve.mail.MailAdapter;
import org.apache.jsieve.parser.generated.ParseException;
import org.apache.jsieve.parser.generated.TokenMgrError;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;
import org.apache.mailet.MailetContext;

public class SieveExecutor {
    private final MailetContext mailetContext;
    private final SievePoster sievePoster;
    private final ResourceLocator resourceLocator;
    private final SieveFactory factory;
    private final ActionDispatcher actionDispatcher;
    private final Log log;

    public static Builder builder() {
        return new Builder();
    }

    public SieveExecutor(MailetContext mailetContext, SievePoster sievePoster, ResourceLocator resourceLocator, Log log) throws MessagingException {
        this.mailetContext = mailetContext;
        this.sievePoster = sievePoster;
        this.resourceLocator = resourceLocator;
        this.factory = this.createFactory(log);
        this.actionDispatcher = new ActionDispatcher();
        this.log = log;
    }

    private SieveFactory createFactory(Log log) throws MessagingException {
        try {
            ConfigurationManager configurationManager = new ConfigurationManager();
            configurationManager.setLog(log);
            return configurationManager.build();
        }
        catch (SieveConfigurationException e) {
            throw new MessagingException("Failed to load standard Sieve configuration.", (Exception)((Object)e));
        }
    }

    public boolean execute(MailAddress recipient, Mail mail) throws MessagingException {
        Preconditions.checkNotNull((Object)recipient, (Object)"Recipient for mail to be spooled cannot be null.");
        Preconditions.checkNotNull((Object)mail.getMessage(), (Object)"Mail message to be spooled cannot be null.");
        return this.sieveMessage(recipient, mail, this.log);
    }

    protected boolean sieveMessage(MailAddress recipient, Mail aMail, Log log) throws MessagingException {
        try {
            ResourceLocator.UserSieveInformation userSieveInformation = this.resourceLocator.get(recipient);
            this.sieveMessageEvaluate(recipient, aMail, userSieveInformation, log);
            return true;
        }
        catch (ScriptNotFoundException e) {
            log.info((Object)("Can not locate SIEVE script for user " + recipient.asPrettyString()));
            return false;
        }
        catch (Exception ex) {
            log.error((Object)("Cannot evaluate Sieve script for user " + recipient.asPrettyString()), (Throwable)ex);
            return false;
        }
    }

    private void sieveMessageEvaluate(MailAddress recipient, Mail aMail, ResourceLocator.UserSieveInformation userSieveInformation, Log log) throws MessagingException, IOException {
        try {
            SieveMailAdapter aMailAdapter = new SieveMailAdapter(aMail, this.mailetContext, this.actionDispatcher, this.sievePoster, userSieveInformation.getScriptActivationDate(), userSieveInformation.getScriptInterpretationDate(), recipient);
            aMailAdapter.setLog(log);
            log.debug((Object)("Evaluating " + aMailAdapter.toString() + " against \"" + recipient.asPrettyString() + "\""));
            this.factory.evaluate((MailAdapter)aMailAdapter, this.factory.parse(userSieveInformation.getScriptContent()));
        }
        catch (SieveException ex) {
            this.handleFailure(recipient, aMail, (Exception)((Object)ex));
        }
        catch (ParseException ex) {
            this.handleFailure(recipient, aMail, (Exception)((Object)ex));
        }
        catch (TokenMgrError ex) {
            this.handleFailure(recipient, aMail, (Exception)((Object)new SieveException((Throwable)ex)));
        }
    }

    protected void handleFailure(MailAddress recipient, Mail aMail, Exception ex) throws MessagingException, IOException {
        this.mailetContext.sendMail(recipient, (Collection)ImmutableList.of((Object)recipient), SieveFailureMessageComposer.composeMessage(aMail, ex, recipient.toString()));
    }

    public static class Builder {
        private MailetContext mailetContext;
        private SievePoster sievePoster;
        private ResourceLocator resourceLocator;
        private Log log;

        public Builder sievePoster(SievePoster sievePoster) {
            this.sievePoster = sievePoster;
            return this;
        }

        public Builder mailetContext(MailetContext mailetContext) {
            this.mailetContext = mailetContext;
            return this;
        }

        public Builder resourceLocator(ResourceLocator resourceLocator) {
            this.resourceLocator = resourceLocator;
            return this;
        }

        public Builder log(Log log) {
            this.log = log;
            return this;
        }

        public SieveExecutor build() throws MessagingException {
            Preconditions.checkNotNull((Object)this.mailetContext);
            Preconditions.checkNotNull((Object)this.resourceLocator);
            Preconditions.checkNotNull((Object)this.log);
            Preconditions.checkNotNull((Object)this.sievePoster);
            return new SieveExecutor(this.mailetContext, this.sievePoster, this.resourceLocator, this.log);
        }
    }
}

