/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.ActionUtils;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class VacationReply {
    private final MailAddress sender;
    private final List<MailAddress> recipients;
    private final MimeMessage mimeMessage;

    public static Builder builder(Mail originalMail, ActionContext context) {
        return new Builder(originalMail, context);
    }

    private VacationReply(MailAddress sender, List<MailAddress> recipients, MimeMessage mimeMessage) {
        this.sender = sender;
        this.recipients = recipients;
        this.mimeMessage = mimeMessage;
    }

    public MailAddress getSender() {
        return this.sender;
    }

    public List<MailAddress> getRecipients() {
        return this.recipients;
    }

    public MimeMessage getMimeMessage() {
        return this.mimeMessage;
    }

    public static class Builder {
        private final Mail originalMail;
        private final ActionContext context;
        private String from;
        private String reason;
        private String mime;
        private String subject;

        public Builder(Mail originalMail, ActionContext context) {
            this.originalMail = originalMail;
            this.context = context;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder mime(String mime) {
            this.mime = mime;
            return this;
        }

        public Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public VacationReply build() throws MessagingException {
            Preconditions.checkState((boolean)this.eitherReasonOrMime());
            ActionUtils.detectAndHandleLocalLooping(this.originalMail, this.context, "vacation");
            MimeMessage reply = (MimeMessage)this.originalMail.getMessage().reply(false);
            reply.setSubject(this.generateNotificationSubject());
            reply.setContent(this.generateNotificationContent());
            return new VacationReply(this.retrieveOriginalSender(), Lists.newArrayList((Object[])new MailAddress[]{this.originalMail.getSender()}), reply);
        }

        private boolean eitherReasonOrMime() {
            return this.reason == null ^ this.mime == null;
        }

        private String generateNotificationSubject() {
            return (String)Optional.fromNullable((Object)this.subject).or((Object)(this.context.getRecipient() + " is currently in vacation"));
        }

        private Multipart generateNotificationContent() throws MessagingException {
            try {
                if (this.reason != null) {
                    return this.generateNotificationContentFromReasonString();
                }
                return this.generateNotificationContentFromMime();
            }
            catch (IOException e) {
                throw new MessagingException("Cannot read specified content", (Exception)e);
            }
        }

        private Multipart generateNotificationContentFromMime() throws MessagingException, IOException {
            return new MimeMultipart((DataSource)new ByteArrayDataSource(this.mime, "mixed"));
        }

        private Multipart generateNotificationContentFromReasonString() throws MessagingException, IOException {
            MimeMultipart multipart = new MimeMultipart("mixed");
            MimeBodyPart reasonPart = new MimeBodyPart();
            reasonPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(this.reason, "text/plain; charset=UTF-8")));
            reasonPart.setDisposition("inline");
            multipart.addBodyPart((BodyPart)reasonPart);
            return multipart;
        }

        private MailAddress retrieveOriginalSender() throws AddressException {
            return (MailAddress)Optional.fromNullable((Object)this.from).transform((Function)new Function<String, MailAddress>(){

                public MailAddress apply(String address) {
                    return Builder.this.retrieveAddressFromString(address, Builder.this.context);
                }
            }).or((Object)this.context.getRecipient());
        }

        private MailAddress retrieveAddressFromString(String address, ActionContext context) {
            try {
                return new MailAddress(address);
            }
            catch (AddressException e) {
                context.getLog().warn((Object)("Mail address " + address + " was not well formatted : " + e.getLocalizedMessage()));
                return null;
            }
        }
    }
}

