/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import java.io.InputStream;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.mailet.MailAddress;
import org.joda.time.DateTime;

public class ResourceLocator {
    private final SieveRepository sieveRepository;
    private final UsersRepository usersRepository;

    public ResourceLocator(SieveRepository sieveRepository, UsersRepository usersRepository) {
        this.sieveRepository = sieveRepository;
        this.usersRepository = usersRepository;
    }

    public UserSieveInformation get(MailAddress mailAddress) throws Exception {
        String username = this.retrieveUsername(mailAddress);
        return new UserSieveInformation(this.sieveRepository.getActivationDateForActiveScript(username), DateTime.now(), this.sieveRepository.getActive(username));
    }

    private String retrieveUsername(MailAddress mailAddress) {
        try {
            return this.usersRepository.getUser(mailAddress);
        }
        catch (UsersRepositoryException e) {
            return mailAddress.asString();
        }
    }

    public static class UserSieveInformation {
        private DateTime scriptActivationDate;
        private DateTime scriptInterpretationDate;
        private InputStream scriptContent;

        public UserSieveInformation(DateTime scriptActivationDate, DateTime scriptInterpretationDate, InputStream scriptContent) {
            this.scriptActivationDate = scriptActivationDate;
            this.scriptInterpretationDate = scriptInterpretationDate;
            this.scriptContent = scriptContent;
        }

        public DateTime getScriptActivationDate() {
            return this.scriptActivationDate;
        }

        public DateTime getScriptInterpretationDate() {
            return this.scriptInterpretationDate;
        }

        public InputStream getScriptContent() {
            return this.scriptContent;
        }
    }
}

