/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.ActionUtils;
import org.apache.james.transport.mailets.jsieve.DiscardAction;
import org.apache.james.transport.mailets.jsieve.MailAction;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionRedirect;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class RedirectAction
implements MailAction {
    @Override
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionRedirect) {
            ActionRedirect actionRedirect = (ActionRedirect)action;
            this.execute(actionRedirect, mail, context);
        }
    }

    public void execute(ActionRedirect anAction, Mail aMail, ActionContext context) throws MessagingException {
        ActionUtils.detectAndHandleLocalLooping(aMail, context, "redirect");
        ArrayList<MailAddress> recipients = new ArrayList<MailAddress>(1);
        recipients.add(new MailAddress(new InternetAddress(anAction.getAddress())));
        MailAddress sender = aMail.getSender();
        context.post(sender, recipients, aMail.getMessage());
        Log log = context.getLog();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Redirected Message ID: " + aMail.getMessage().getMessageID() + " to \"" + anAction.getAddress() + "\""));
        }
        DiscardAction.removeRecipient(aMail, context);
    }
}

