/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.ActionUtils;
import org.apache.james.transport.mailets.jsieve.MailAction;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionFileInto;
import org.apache.mailet.Mail;
import org.apache.mailet.MailAddress;

public class FileIntoAction
implements MailAction {
    private static final char HIERARCHY_DELIMITER = '.';

    @Override
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionFileInto) {
            ActionFileInto fileIntoAction = (ActionFileInto)action;
            this.execute(fileIntoAction, mail, context);
        }
    }

    public void execute(ActionFileInto anAction, Mail aMail, ActionContext context) throws MessagingException {
        Log log;
        String destinationMailbox = anAction.getDestination();
        boolean delivered = false;
        try {
            MailAddress recipient = ActionUtils.getSoleRecipient(aMail);
            if (destinationMailbox.length() <= 0 || destinationMailbox.charAt(0) != '.') {
                destinationMailbox = '.' + destinationMailbox;
            }
            String mailbox = destinationMailbox.replace('.', '/');
            String url = "mailbox://" + recipient.asString() + mailbox;
            context.post(url, aMail);
            delivered = true;
        }
        catch (MessagingException ex) {
            Log log2 = context.getLog();
            if (log2.isDebugEnabled()) {
                log2.debug((Object)("Error while storing mail into. " + destinationMailbox), (Throwable)ex);
            }
            throw ex;
        }
        if (delivered && (log = context.getLog()).isDebugEnabled()) {
            log.debug((Object)("Filed Message ID: " + aMail.getMessage().getMessageID() + " into destination: \"" + destinationMailbox + "\""));
        }
    }
}

